<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    include_once '../../config/Database.php';
    include_once '../../models/Categoria.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();
    
    // INSTANTIATE POST OBJECT
    $categoria = new Categoria($db);
    
    // BLOG POST QUERY
    $result = $categoria->read();
    
    // GET ROW COUNT
    $num = $result->rowCount();
    
    // CHECK IF ANY POSTS
    if($num > 0){
        // POST ARRAY
        $categorias_arr = array();
        $categorias_arr['data'] = array();

        while($row = $result->fetch(PDO::FETCH_ASSOC)){
            extract($row);

            $categoria_item = array(
                'id' => $id,
                'produtoCategoria' => $produtoCategoria,
            );

            // PUSH TO 'DATA'
            array_push($categorias_arr['data'], $categoria_item);
        }

    // TURN TO JSON AND OUTPUT
    echo json_encode($categorias_arr);

    }else{
        // NO POSTS
        echo json_encode(
            array('message' => 'No Posts Found')
        );
    }
}