<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header('Access-Control-Allow-Methods: PUT');
    header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');

    include_once '../../config/Database.php';
    include_once '../../models/Categoria.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();

    // INSTANTIATE POST OBJECT
    $categoria = new Categoria($db);

    // GET RAW POSTED DATA
    $data = json_decode(file_get_contents("php://input"));

    // SET ID TO UPDATE
    $categoria->id = $data->id;

    $categoria->produtoCategoria = $data->produtoCategoria;

    // UPDATE POST
    if($categoria->update()){
        echo json_encode(
            array('message' => 'Post Update')
        );
    } else {
        echo json_encode(
            array('message' => 'Post Not Update')
        );
    }
