<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    include_once '../../config/Database.php';
    include_once '../../models/Fabricante.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();
    
    // INSTANTIATE POST OBJECT
    $fabricante = new Fabricante($db);
    
    // BLOG POST QUERY
    $result = $fabricante->read();
    
    // GET ROW COUNT
    $num = $result->rowCount();
    
    // CHECK IF ANY POSTS
    if($num > 0){
        // POST ARRAY
        $fabricantes_arr = array();
        $fabricantes_arr['data'] = array();

        while($row = $result->fetch(PDO::FETCH_ASSOC)){
            extract($row);

            $fabricante_item = array(
                'id' => $id,
                'produtoFabricante' => $produtoFabricante
            );

            // PUSH TO 'DATA'
            array_push($fabricantes_arr['data'], $fabricante_item);
        }

    // TURN TO JSON AND OUTPUT
    echo json_encode($fabricantes_arr);

    }else{
        // NO POSTS
        echo json_encode(
            array('message' => 'No Posts Found')
        );
    }
}