<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header('Access-Control-Allow-Methods: DELETE');
    header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');

    include_once '../../config/Database.php';
    include_once '../../models/Historico.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();

    // INSTANTIATE POST OBJECT
    $historico = new Historico($db);

    // GET RAW POSTED DATA
    $data = json_decode(file_get_contents("php://input"));

    // SET ID TO UPDATE
    $historico->id = $data->id;

    // DELETE POST
    if($historico->delete()){
        echo json_encode(
            array('message' => 'Post Deleted')
        );
    } else {
        echo json_encode(
            array('message' => 'Post Not Deleted')
        );
    }
