<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    include_once '../../config/Database.php';
    include_once '../../models/Historico.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();
    
    // INSTANTIATE POST OBJECT
    $historico = new Historico($db);
    
    // BLOG POST QUERY
    $result = $historico->read();
    
    // GET ROW COUNT
    $num = $result->rowCount();
    
    // CHECK IF ANY POSTS
    if($num > 0){
        // POST ARRAY
        $historico_arr = array();
        $historico_arr['data'] = array();

        while($row = $result->fetch(PDO::FETCH_ASSOC)){
            extract($row);

            $historico_item = array(
                'id' => $id,
                
                'data' => $data,
                'editadoPor' => $editadoPor,
                
                'produtoCodigoAntes' => $produtoCodigoAntes,
                'produtoCategoriaAntes' => $produtoCategoriaAntes,
                'produtoDescricaoAntes' => $produtoDescricaoAntes,
                'produtoFabricanteAntes' => $produtoFabricanteAntes,
                'produtoQuantidadeAntes' => $produtoQuantidadeAntes,
                'produtoUnidadeMedidaAntes' => $produtoUnidadeMedidaAntes,
                'produtoQuantidadeCaixaAntes' => $produtoQuantidadeCaixaAntes,
                'produtoLocalAntes' => $produtoLocalAntes,
                'produtoPosicaoAntes' => $produtoPosicaoAntes,
                'produtoCondicaoNovoAntes' => $produtoCondicaoNovoAntes,
                'produtoCondicaoUsadoAntes' => $produtoCondicaoUsadoAntes,
                'produtoCondicaoAbertoAntes' => $produtoCondicaoAbertoAntes,
                'produtoCondicaoSemCaixaAntes' => $produtoCondicaoSemCaixaAntes,
                'produtoCondicaoReparadoAntes' => $produtoCondicaoReparadoAntes,
                'produtoCondicaoSemReparoAntes' => $produtoCondicaoSemReparoAntes,
                'produtoObservacaoAntes' => $produtoObservacaoAntes,
                'produtoValorEstoqueAntes' => $produtoValorEstoqueAntes,
                'produtoValorRealAntes' => $produtoValorRealAntes,
                'produtoLinkMLAntes' => $produtoLinkMLAntes,
                'produtoUltimaAtualizacaoAntes' => $produtoUltimaAtualizacaoAntes,
                
                'produtoCodigoDepois' => $produtoCodigoDepois,
                'produtoCategoriaDepois' => $produtoCategoriaDepois,
                'produtoDescricaoDepois' => $produtoDescricaoDepois,
                'produtoFabricanteDepois' => $produtoFabricanteDepois,
                'produtoQuantidadeDepois' => $produtoQuantidadeDepois,
                'produtoUnidadeMedidaDepois' => $produtoUnidadeMedidaDepois,
                'produtoQuantidadeCaixaDepois' => $produtoQuantidadeCaixaDepois,
                'produtoLocalDepois' => $produtoLocalDepois,
                'produtoPosicaoDepois' => $produtoPosicaoDepois,
                'produtoCondicaoNovoDepois' => $produtoCondicaoNovoDepois,
                'produtoCondicaoUsadoDepois' => $produtoCondicaoUsadoDepois,
                'produtoCondicaoAbertoDepois' => $produtoCondicaoAbertoDepois,
                'produtoCondicaoSemCaixaDepois' => $produtoCondicaoSemCaixaDepois,
                'produtoCondicaoReparadoDepois' => $produtoCondicaoReparadoDepois,
                'produtoCondicaoSemReparoDepois' => $produtoCondicaoSemReparoDepois,
                'produtoObservacaoDepois' => $produtoObservacaoDepois,
                'produtoValorEstoqueDepois' => $produtoValorEstoqueDepois,
                'produtoValorRealDepois' => $produtoValorRealDepois,
                'produtoLinkMLDepois' => $produtoLinkMLDepois,
                'produtoUltimaAtualizacaoDepois' => $produtoUltimaAtualizacaoDepois
                
            );

            // PUSH TO 'DATA'
            array_push($historico_arr['data'], $historico_item);
        }

    // TURN TO JSON AND OUTPUT
    echo json_encode($historico_arr);

    }else{
        // NO POSTS
        echo json_encode(
            array('message' => 'No Posts Found')
        );
    }
}