<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header('Access-Control-Allow-Methods: PUT');
    header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');

    include_once '../../config/Database.php';
    include_once '../../models/Historico.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();

    // INSTANTIATE POST OBJECT
    $historico = new Historico($db);

    // GET RAW POSTED DATA
    $data = json_decode(file_get_contents("php://input"));

    // SET ID TO UPDATE
    $historico->id = $data->id;

    $historico->produtoCodigoAntes = $data->produtoCodigoAntes;
    $historico->produtoCategoriaAntes = $data->produtoCategoriaAntes;
    $historico->produtoDescricaoAntes = $data->produtoDescricaoAntes;
    $historico->produtoFabricanteAntes = $data->produtoFabricanteAntes;
    $historico->produtoQuantidadeAntes = $data->produtoQuantidadeAntes;
    $historico->produtoUnidadeMedidaAntes = $data->produtoUnidadeMedidaAntes;
    $historico->produtoQuantidadeCaixaAntes = $data->produtoQuantidadeCaixaAntes;
    $historico->produtoLocalAntes = $data->produtoLocalAntes;
    $historico->produtoPosicaoAntes = $data->produtoPosicaoAntes;
    $historico->produtoCondicaoNovoAntes = $data->produtoCondicaoNovoAntes;
    $historico->produtoCondicaoUsadoAntes = $data->produtoCondicaoUsadoAntes;
    $historico->produtoCondicaoAbertoAntes = $data->produtoCondicaoAbertoAntes;
    $historico->produtoCondicaoSemCaixaAntes = $data->produtoCondicaoSemCaixaAntes;
    $historico->produtoCondicaoReparadoAntes = $data->produtoCondicaoReparadoAntes;
    $historico->produtoCondicaoSemReparoAntes = $data->produtoCondicaoSemReparoAntes;
    $historico->produtoObservacaoAntes = $data->produtoObservacaoAntes;
    $historico->produtoValorEstoqueAntes = $data->produtoValorEstoqueAntes;
    $historico->produtoValorRealAntes = $data->produtoValorRealAntes;
    $historico->produtoLinkMLAntes = $data->produtoLinkMLAntes;
    $historico->produtoUltimaAtualizacaoAntes = $data->produtoUltimaAtualizacaoAntes;
    
    $historico->produtoCodigoDepois = $data->produtoCodigoDepois;
    $historico->produtoCategoriaDepois = $data->produtoCategoriaDepois;
    $historico->produtoDescricaoDepois = $data->produtoDescricaoDepois;
    $historico->produtoFabricanteDepois = $data->produtoFabricanteDepois;
    $historico->produtoQuantidadeDepois = $data->produtoQuantidadeDepois;
    $historico->produtoUnidadeMedidaDepois = $data->produtoUnidadeMedidaDepois;
    $historico->produtoQuantidadeCaixaDepois = $data->produtoQuantidadeCaixaDepois;
    $historico->produtoLocalDepois = $data->produtoLocalDepois;
    $historico->produtoPosicaoDepois = $data->produtoPosicaoDepois;
    $historico->produtoCondicaoNovoDepois = $data->produtoCondicaoNovoDepois;
    $historico->produtoCondicaoUsadoDepois = $data->produtoCondicaoUsadoDepois;
    $historico->produtoCondicaoAbertoDepois = $data->produtoCondicaoAbertoDepois;
    $historico->produtoCondicaoSemCaixaDepois = $data->produtoCondicaoSemCaixaDepois;
    $historico->produtoCondicaoReparadoDepois = $data->produtoCondicaoReparadoDepois;
    $historico->produtoCondicaoSemReparoDepois = $data->produtoCondicaoSemReparoDepois;
    $historico->produtoObservacaoDepois = $data->produtoObservacaoDepois;
    $historico->produtoValorEstoqueDepois = $data->produtoValorEstoqueDepois;
    $historico->produtoValorRealDepois = $data->produtoValorRealDepois;
    $historico->produtoLinkMLDepois = $data->produtoLinkMLDepois;
    $historico->produtoUltimaAtualizacaoDepois = $data->produtoUltimaAtualizacaoDepois;
    
    // UPDATE POST
    if($historico->update()){
        echo json_encode(
            array('message' => 'Post Update')
        );
    } else {
        echo json_encode(
            array('message' => 'Post Not Update')
        );
    }
