<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    include_once '../../config/Database.php';
    include_once '../../models/Movimentacao.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();
    
    // INSTANTIATE POST OBJECT
    $movimentacao = new Movimentacao($db);
    
    // BLOG POST QUERY
    $result = $movimentacao->read();
    
    // GET ROW COUNT
    $num = $result->rowCount();
    
    // CHECK IF ANY POSTS
    if($num > 0){
        // POST ARRAY
        $movimentacao_arr = array();
        $movimentacao_arr['data'] = array();

        while($row = $result->fetch(PDO::FETCH_ASSOC)){
            extract($row);

            $movimentacao_item = array(
                'id' => $id,
                'movimentacaoTipo' => $movimentacaoTipo,
                'movimentacaoResponsavel' => $movimentacaoResponsavel,
                'movimentacaoDD' => $movimentacaoDD,
                'movimentacaoOS' => $movimentacaoOS,
                'movimentacaoMotivo' => $movimentacaoMotivo,
                'movimentacaoObservacao' => $movimentacaoObservacao,
                'movimentacaoData' => $movimentacaoData,
                'movimentacaoidProduto' => $movimentacaoidProduto,
                'movimentacaoQuantidadeProduto' => $movimentacaoQuantidadeProduto,
                'movimentacaoFilter' => $movimentacaoFilter,
                'movimentacaoUnidadeCliente' => $movimentacaoUnidadeCliente,
                'movimentacaoNomeCliente' => $movimentacaoNomeCliente,
                'movimentacaoAtendimento' => $movimentacaoAtendimento,
                'movimentacaoTeste' => $movimentacaoTeste,
                'movimentacaoEmprestimo' => $movimentacaoEmprestimo,
                'movimentacaoStatus' => $movimentacaoStatus,
                'movimentacaoSaldoEstoque' => $movimentacaoSaldoEstoque
            );

            // PUSH TO 'DATA'
            array_push($movimentacao_arr['data'], $movimentacao_item);
        }

    // TURN TO JSON AND OUTPUT
    echo json_encode($movimentacao_arr);

    }else{
        // NO POSTS
        echo json_encode(
            array('message' => 'No PrmeOSts Found')
        );
    }
}