<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    include_once '../../config/Database.php';
    include_once '../../models/Posicao.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();
    
    // INSTANTIATE POST OBJECT
    $posicao = new Posicao($db);
    
    // BLOG POST QUERY
    $result = $posicao->read();
    
    // GET ROW COUNT
    $num = $result->rowCount();
    
    // CHECK IF ANY POSTS
    if($num > 0){
        // POST ARRAY
        $posicoes_arr = array();
        $posicoes_arr['data'] = array();

        while($row = $result->fetch(PDO::FETCH_ASSOC)){
            extract($row);

            $posicao_item = array(
                'id' => $id,
                'produtoPosicao' => $produtoPosicao
            );

            // PUSH TO 'DATA'
            array_push($posicoes_arr['data'], $posicao_item);
        }

    // TURN TO JSON AND OUTPUT
    echo json_encode($posicoes_arr);

    }else{
        // NO POSTS
        echo json_encode(
            array('message' => 'No Posts Found')
        );
    }
}