<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header('Access-Control-Allow-Methods: POST');
    header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    include_once '../../config/Database.php';
    include_once '../../models/Produto.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();

    // INSTANTIATE POST OBJECT
    $produto = new Produto($db);

    // GET RAW POSTED DATA
    $data = json_decode(file_get_contents("php://input"));

    $produto->produtoCodigo = $data->produtoCodigo;
    $produto->produtoCategoria = $data->produtoCategoria;
    $produto->produtoDescricao = $data->produtoDescricao;
    $produto->produtoFabricante = $data->produtoFabricante;
    $produto->produtoQuantidade = $data->produtoQuantidade;
    $produto->produtoUnidadeMedida = $data->produtoUnidadeMedida;
    $produto->produtoQuantidadeCaixa = $data->produtoQuantidadeCaixa;
    $produto->produtoLocal = $data->produtoLocal;
    $produto->produtoPosicao = $data->produtoPosicao;
    $produto->produtoCondicaoNovo = $data->produtoCondicaoNovo;
    $produto->produtoCondicaoUsado = $data->produtoCondicaoUsado;
    $produto->produtoCondicaoAberto = $data->produtoCondicaoAberto;
    $produto->produtoCondicaoSemCaixa = $data->produtoCondicaoSemCaixa;
    $produto->produtoCondicaoReparado = $data->produtoCondicaoReparado;
    $produto->produtoCondicaoSemReparo = $data->produtoCondicaoSemReparo;
    $produto->produtoObservacao = $data->produtoObservacao;
    $produto->produtoValorEstoque = $data->produtoValorEstoque;
    $produto->produtoValorReal = $data->produtoValorReal;
    $produto->produtoLinkML = $data->produtoLinkML;
    $produto->produtoUltimaAtualizacao = $data->produtoUltimaAtualizacao;
    
    // CREATE POST
    if($produto->create()){
        echo json_encode(
            array('message' => 'Post Created')
        );
    } else {
        echo json_encode(
            array('message' => 'Post Not Created')
        );
    }
}