<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    include_once '../../config/Database.php';
    include_once '../../models/Produto.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();
    
    // INSTANTIATE POST OBJECT
    $produto = new Produto($db);
    
    // BLOG POST QUERY
    $result = $produto->read();
    
    // GET ROW COUNT
    $num = $result->rowCount();
    
    // CHECK IF ANY POSTS
    if($num > 0){
        // POST ARRAY
        $produtos_arr = array();
        $produtos_arr['data'] = array();

        while($row = $result->fetch(PDO::FETCH_ASSOC)){
            extract($row);

            $produto_item = array(
                'id' => $id,
                'produtoCodigo' => $produtoCodigo,
                'produtoCategoria' => $produtoCategoria,
                'produtoDescricao' => $produtoDescricao,
                'produtoFabricante' => $produtoFabricante,
                'produtoQuantidade' => $produtoQuantidade,
                'produtoUnidadeMedida' => $produtoUnidadeMedida,
                'produtoQuantidadeCaixa' => $produtoQuantidadeCaixa,
                'produtoLocal' => $produtoLocal,
                'produtoPosicao' => $produtoPosicao,
                'produtoCondicaoNovo' => $produtoCondicaoNovo,
                'produtoCondicaoUsado' => $produtoCondicaoUsado,
                'produtoCondicaoAberto' => $produtoCondicaoAberto,
                'produtoCondicaoSemCaixa' => $produtoCondicaoSemCaixa,
                'produtoCondicaoReparado' => $produtoCondicaoReparado,
                'produtoCondicaoSemReparo' => $produtoCondicaoSemReparo,
                'produtoObservacao' => $produtoObservacao,
                'produtoValorEstoque' => $produtoValorEstoque,
                'produtoValorReal' => $produtoValorReal,
                'produtoLinkML' => $produtoLinkML,
                'produtoUltimaAtualizacao' => $produtoUltimaAtualizacao
            );

            // PUSH TO 'DATA'
            array_push($produtos_arr['data'], $produto_item);
        }

    // TURN TO JSON AND OUTPUT
    echo json_encode($produtos_arr);

    }else{
        // NO POSTS
        echo json_encode(
            array('message' => 'No Posts Found')
        );
    }
}