<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');
if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    include_once '../../config/Database.php';
    include_once '../../models/Produto.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();

    // INSTANTIATE POST OBJECT
    $produto = new Produto($db);

    // GET ID
    $produto->id = isset($_GET['id']) ? $_GET['id'] : die();

    // GET POST
    $produto->read_single();

    // CREATE ARRAY
    $produto_arr = array(
        'id' => $produto->id,
        'produtoCodigo' => $produto->produtoCodigo,
        'produtoCategoria' => $produto->produtoCategoria,
        'produtoDescricao' => $produto->produtoDescricao,
        'produtoFabricante' => $produto->produtoFabricante,
        'produtoQuantidade' => $produto->produtoQuantidade,
        'produtoUnidadeMedida' => $produto->produtoUnidadeMedida,
        'produtoQuantidadeCaixa' => $produto->produtoQuantidadeCaixa,
        'produtoLocal' => $produto->produtoLocal,
        'produtoPosicao' => $produto->produtoPosicao,
        'produtoCondicaoNovo' => $produto->produtoCondicaoNovo,
        'produtoCondicaoUsado' => $produto->produtoCondicaoUsado,
        'produtoCondicaoAberto' => $produto->produtoCondicaoAberto,
        'produtoCondicaoSemCaixa' => $produto->produtoCondicaoSemCaixa,
        'produtoCondicaoReparado' => $produto->produtoCondicaoReparado,
        'produtoCondicaoSemReparo' => $produto->produtoCondicaoSemReparo,
        'produtoObservacao' => $produto->produtoObservacao,
        'produtoValorEstoque' => $produto->produtoValorEstoque,
        'produtoValorReal' => $produto->produtoValorReal,
        'produtoLinkML' => $produto->produtoLinkML,
        'produtoUltimaAtualizacao' => $produto->produtoUltimaAtualizacao
    );

    // MAKE JSON
    print_r(json_encode($produto_arr));
}