<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    include_once '../../config/Database.php';
    include_once '../../models/RME.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();
    
    // INSTANTIATE POST OBJECT
    $rme = new RME($db);
    
    // BLOG POST QUERY
    $result = $rme->read();
    
    // GET ROW COUNT
    $num = $result->rowCount();
    
    // CHECK IF ANY POSTS
    if($num > 0){
        // POST ARRAY
        $rme_arr = array();
        $rme_arr['data'] = array();

        while($row = $result->fetch(PDO::FETCH_ASSOC)){
            extract($row);

            $rme_item = array(
                'id' => $id,
                'rmeResponsavel' => $rmeResponsavel,
                'rmeDD' => $rmeDD,
                'rmeOS' => $rmeOS,
                'rmeDescricao' => $rmeDescricao,
                'rmeObservacao' => $rmeObservacao,
                'rmeData' => $rmeData,
                'rmeidProduto' => $rmeidProduto,
                'rmeFilter' => $rmeFilter,
                'rmeAutorizar' => $rmeAutorizar,
                'rmeCriadoPor' => $rmeCriadoPor,
                'rmeObservacaoGeral' => $rmeObservacaoGeral,
                'rmeUnidadeCliente' => $rmeUnidadeCliente,
                'rmeNomeCliente' => $rmeNomeCliente,
                'rmeAtendimento' => $rmeAtendimento,
                'rmeTeste' => $rmeTeste,
                'rmeEmprestimo' => $rmeEmprestimo,
                'rmeStatus' => $rmeStatus,
                'rmeQuantidadeProduto' => $rmeQuantidadeProduto
            );

            // PUSH TO 'DATA'
            array_push($rme_arr['data'], $rme_item);
        }

    // TURN TO JSON AND OUTPUT
    echo json_encode($rme_arr);

    }else{
        // NO POSTS
        echo json_encode(
            array('message' => 'No PrmeOSts Found')
        );
    }
}