<?php
    // HEADERS
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header('Access-Control-Allow-Methods: PUT');
    header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');

    include_once '../../config/Database.php';
    include_once '../../models/Usuario.php';

    // INSTANTIATE DB AND CONNECT
    $database = new Database();
    $db = $database->connect();

    // INSTANTIATE POST OBJECT
    $usuario = new Usuario($db);

    // GET RAW POSTED DATA
    $data = json_decode(file_get_contents("php://input"));

    // SET ID TO UPDATE
    $usuario->id = $data->id;

    $usuario->usuario = $data->usuario;
    $usuario->nome = $data->nome;
    $usuario->senha = $data->senha;
    $usuario->permissao = $data->permissao;
    $usuario->bloqueado = $data->bloqueado;

    // UPDATE POST
    if($usuario->update()){
        echo json_encode(
            array('message' => 'PrmeOSt Update')
        );
    } else {
        echo json_encode(
            array('message' => 'PrmeOSt Not Update')
        );
    }
