<?php

Class Categoria{
    // DB STUFF
    private $conn;
    private $table = 'listaCategorias';

    // POST PROPERTIES
    public $id;
    public $produtoCategoria;

    // CONSTRUCTOR WITH DB
    public function __construct($db){
        $this->conn = $db;
    }
    
    // GET POST
    public function read(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.produtoCategoria
        FROM
            ' . $this->table . ' p
        ORDER BY
            p.produtoCategoria ASC';
    
    // PREPARE STATEMENT
    $stmt = $this->conn->prepare($query);

    // EXECUTE QUERY
    $stmt->execute();
    
    return $stmt;
    }

    // GET SINGLE POST
    public function read_single(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.produtoCategoria
        FROM
            ' . $this->table . ' p
        WHERE
            p.id = ?
        LIMIT 0,1';

        // PREPARE STATEMENT
        $stmt = $this->conn->prepare($query);

        // BIND ID
        $stmt->bindParam(1, $this->id);

        // EXECUTE QUERY
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        // SET PROPERTIES
        $this->produtoCategoria = $row['produtoCategoria'];
    }

    // CREATE POST
    public function create(){
    
    // CREATE QUERY
    $query= 'INSERT INTO ' . $this->table . '
        SET
            produtoCategoria = :produtoCategoria';

    // PREPARE STATEMENTE
    $stmt = $this->conn->prepare($query);

    // CLEAN DATA
    $this->produtoCategoria = htmlspecialchars(strip_tags($this->produtoCategoria));

    // BIND DATA
    $stmt->bindParam(':produtoCategoria', $this->produtoCategoria);

    // EXECUTE QUERY
    if($stmt->execute()){
        return true;
    }

    // PRINT ERROR IF SOMETHING GOES WRONG
    printf("Error: %s.\n",$stmt->error);

        return false;
    }

    // UPDATE POST
    public function update(){
    
        // CREATE QUERY
        $query= 'UPDATE ' . $this->table . '
            SET
                produtoCategoria = :produtoCategoria
            WHERE
                id = :id';
    
        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);
    
        // CLEAN DATA
    $this->id = htmlspecialchars(strip_tags($this->id));
    $this->produtoCategoria = htmlspecialchars(strip_tags($this->produtoCategoria));

    // BIND DATA
    $stmt->bindParam(':id', $this->id);
    $stmt->bindParam(':produtoCategoria', $this->produtoCategoria);
    
        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;
        }

    // DELETE POST
    public function delete(){
        
        // CREATE QUERY
        $query = 'DELETE FROM '. $this->table . ' WHERE id = :id';

        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);

        // CLEAN DATA
        $this->id = htmlspecialchars(strip_tags($this->id));

        // BIND DATA
        $stmt->bindParam(':id', $this->id);

        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;           
        }
}