<?php

Class Historico{
    // DB STUFF
    private $conn;
    private $table = 'listaHistorico';

    // POST PROPERTIES
    public $id;
    public $data;
    public $editadoPor;
    public $produtoCodigoAntes;
    public $produtoCategoriaAntes;
    public $produtoDescricaoAntes;
    public $produtoFabricanteAntes;
    public $produtoQuantidadeAntes;
    public $produtoUnidadeMedidaAntes;
    public $produtoQuantidadeCaixaAntes;
    public $produtoLocalAntes;
    public $produtoPosicaoAntes;
    public $produtoCondicaoNovoAntes;
    public $produtoCondicaoUsadoAntes;
    public $produtoCondicaoAbertoAntes;
    public $produtoCondicaoSemCaixaAntes;
    public $produtoCondicaoReparadoAntes;
    public $produtoCondicaoSemReparoAntes;
    public $produtoObservacaoAntes;
    public $produtoValorEstoqueAntes;
    public $produtoValorRealAntes;
    public $produtoLinkMLAntes;
    public $produtoUltimaAtualizacaoAntes;
    public $produtoCodigoDepois;
    public $produtoCategoriaDepois;
    public $produtoDescricaoDepois;
    public $produtoFabricanteDepois;
    public $produtoQuantidadeDepois;
    public $produtoUnidadeMedidaDepois;
    public $produtoQuantidadeCaixaDepois;
    public $produtoLocalDepois;
    public $produtoPosicaoDepois;
    public $produtoCondicaoNovoDepois;
    public $produtoCondicaoUsadoDepois;
    public $produtoCondicaoAbertoDepois;
    public $produtoCondicaoSemCaixaDepois;
    public $produtoCondicaoReparadoDepois;
    public $produtoCondicaoSemReparoDepois;
    public $produtoObservacaoDepois;
    public $produtoValorEstoqueDepois;
    public $produtoValorRealDepois;
    public $produtoLinkMLDepois;
    public $produtoUltimaAtualizacaoDepois;

    // CONSTRUCTOR WITH DB
    public function __construct($db){
        $this->conn = $db;
    }
    
    // GET POST
    public function read(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.data,
            p.editadoPor,
            p.produtoCodigoAntes,
            p.produtoCategoriaAntes,
            p.produtoDescricaoAntes,
            p.produtoFabricanteAntes,
            p.produtoQuantidadeAntes,
            p.produtoUnidadeMedidaAntes,
            p.produtoQuantidadeCaixaAntes,
            p.produtoLocalAntes,
            p.produtoPosicaoAntes,
            p.produtoCondicaoNovoAntes,
            p.produtoCondicaoUsadoAntes,
            p.produtoCondicaoAbertoAntes,
            p.produtoCondicaoSemCaixaAntes,
            p.produtoCondicaoReparadoAntes,
            p.produtoCondicaoSemReparoAntes,
            p.produtoObservacaoAntes,
            p.produtoValorEstoqueAntes,
            p.produtoValorRealAntes,
            p.produtoLinkMLAntes,
            p.produtoUltimaAtualizacaoAntes,
            p.produtoCodigoDepois,
            p.produtoCategoriaDepois,
            p.produtoDescricaoDepois,
            p.produtoFabricanteDepois,
            p.produtoQuantidadeDepois,
            p.produtoUnidadeMedidaDepois,
            p.produtoQuantidadeCaixaDepois,
            p.produtoLocalDepois,
            p.produtoPosicaoDepois,
            p.produtoCondicaoNovoDepois,
            p.produtoCondicaoUsadoDepois,
            p.produtoCondicaoAbertoDepois,
            p.produtoCondicaoSemCaixaDepois,
            p.produtoCondicaoReparadoDepois,
            p.produtoCondicaoSemReparoDepois,
            p.produtoObservacaoDepois,
            p.produtoValorEstoqueDepois,
            p.produtoValorRealDepois,
            p.produtoLinkMLDepois,
            p.produtoUltimaAtualizacaoDepois
        FROM
            ' . $this->table . ' p
        ORDER BY
            p.id ASC';
    
    // PREPARE STATEMENT
    $stmt = $this->conn->prepare($query);

    // EXECUTE QUERY
    $stmt->execute();
    
    return $stmt;
    }

    // GET SINGLE POST
    public function read_single(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.data,
            p.editadoPor,
            p.produtoCodigoAntes,
            p.produtoCategoriaAntes,
            p.produtoDescricaoAntes,
            p.produtoFabricanteAntes,
            p.produtoQuantidadeAntes,
            p.produtoUnidadeMedidaAntes,
            p.produtoQuantidadeCaixaAntes,
            p.produtoLocalAntes,
            p.produtoPosicaoAntes,
            p.produtoCondicaoNovoAntes,
            p.produtoCondicaoUsadoAntes,
            p.produtoCondicaoAbertoAntes,
            p.produtoCondicaoSemCaixaAntes,
            p.produtoCondicaoReparadoAntes,
            p.produtoCondicaoSemReparoAntes,
            p.produtoObservacaoAntes,
            p.produtoValorEstoqueAntes,
            p.produtoValorRealAntes,
            p.produtoLinkMLAntes,
            p.produtoUltimaAtualizacaoAntes,
            p.produtoCodigoDepois,
            p.produtoCategoriaDepois,
            p.produtoDescricaoDepois,
            p.produtoFabricanteDepois,
            p.produtoQuantidadeDepois,
            p.produtoUnidadeMedidaDepois,
            p.produtoQuantidadeCaixaDepois,
            p.produtoLocalDepois,
            p.produtoPosicaoDepois,
            p.produtoCondicaoNovoDepois,
            p.produtoCondicaoUsadoDepois,
            p.produtoCondicaoAbertoDepois,
            p.produtoCondicaoSemCaixaDepois,
            p.produtoCondicaoReparadoDepois,
            p.produtoCondicaoSemReparoDepois,
            p.produtoObservacaoDepois,
            p.produtoValorEstoqueDepois,
            p.produtoValorRealDepois,
            p.produtoLinkMLDepois,
            p.produtoUltimaAtualizacaoDepois
        FROM
            ' . $this->table . ' p
        WHERE
            p.id = ?
        LIMIT 0,1';

        // PREPARE STATEMENT
        $stmt = $this->conn->prepare($query);

        // BIND ID
        $stmt->bindParam(1, $this->id);

        // EXECUTE QUERY
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        // SET PROPERTIES
        $this->data = $row['data'];
        $this->editadoPor = $row['editadoPor'];
        $this->produtoCodigoAntes = $row['produtoCodigoAntes'];
        $this->produtoCategoriaAntes = $row['produtoCategoriaAntes'];
        $this->produtoDescricaoAntes = $row['produtoDescricaoAntes'];
        $this->produtoFabricanteAntes = $row['produtoFabricanteAntes'];
        $this->produtoQuantidadeAntes = $row['produtoQuantidadeAntes'];
        $this->produtoUnidadeMedidaAntes = $row['produtoUnidadeMedidaAntes'];
        $this->produtoQuantidadeCaixaAntes = $row['produtoQuantidadeCaixaAntes'];
        $this->produtoLocalAntes = $row['produtoLocalAntes'];
        $this->produtoPosicaoAntes = $row['produtoPosicaoAntes'];
        $this->produtoCondicaoNovoAntes = $row['produtoCondicaoNovoAntes'];
        $this->produtoCondicaoUsadoAntes = $row['produtoCondicaoUsadoAntes'];
        $this->produtoCondicaoAbertoAntes = $row['produtoCondicaoAbertoAntes'];
        $this->produtoCondicaoSemCaixaAntes = $row['produtoCondicaoSemCaixaAntes'];
        $this->produtoCondicaoReparadoAntes = $row['produtoCondicaoReparadoAntes'];
        $this->produtoCondicaoSemReparoAntes = $row['produtoCondicaoSemReparoAntes'];
        $this->produtoObservacaoAntes = $row['produtoObservacaoAntes'];
        $this->produtoValorEstoqueAntes = $row['produtoValorEstoqueAntes'];
        $this->produtoValorRealAntes = $row['produtoValorRealAntes'];
        $this->produtoLinkMLAntes = $row['produtoLinkMLAntes'];
        $this->produtoUltimaAtualizacaoAntes = $row['produtoUltimaAtualizacaoAntes'];
        $this->produtoCodigoDepois = $row['produtoCodigoDepois'];
        $this->produtoCategoriaDepois = $row['produtoCategoriaDepois'];
        $this->produtoDescricaoDepois = $row['produtoDescricaoDepois'];
        $this->produtoFabricanteDepois = $row['produtoFabricanteDepois'];
        $this->produtoQuantidadeDepois = $row['produtoQuantidadeDepois'];
        $this->produtoUnidadeMedidaDepois = $row['produtoUnidadeMedidaDepois'];
        $this->produtoQuantidadeCaixaDepois = $row['produtoQuantidadeCaixaDepois'];
        $this->produtoLocalDepois = $row['produtoLocalDepois'];
        $this->produtoPosicaoDepois = $row['produtoPosicaoDepois'];
        $this->produtoCondicaoNovoDepois = $row['produtoCondicaoNovoDepois'];
        $this->produtoCondicaoUsadoDepois = $row['produtoCondicaoUsadoDepois'];
        $this->produtoCondicaoAbertoDepois = $row['produtoCondicaoAbertoDepois'];
        $this->produtoCondicaoSemCaixaDepois = $row['produtoCondicaoSemCaixaDepois'];
        $this->produtoCondicaoReparadoDepois = $row['produtoCondicaoReparadoDepois'];
        $this->produtoCondicaoSemReparoDepois = $row['produtoCondicaoSemReparoDepois'];
        $this->produtoObservacaoDepois = $row['produtoObservacaoDepois'];
        $this->produtoValorEstoqueDepois = $row['produtoValorEstoqueDepois'];
        $this->produtoValorRealDepois = $row['produtoValorRealDepois'];
        $this->produtoLinkMLDepois = $row['produtoLinkMLDepois'];
        $this->produtoUltimaAtualizacaoDepois = $row['produtoUltimaAtualizacaoDepois'];
        
    }

    // CREATE POST
    public function create(){
    
    // CREATE QUERY
    $query= 'INSERT INTO ' . $this->table . '
        SET
            data = :data,
            editadoPor = :editadoPor,
            
            produtoCodigoAntes = :produtoCodigoAntes,
            produtoCategoriaAntes = :produtoCategoriaAntes,
            produtoDescricaoAntes = :produtoDescricaoAntes,
            produtoFabricanteAntes = :produtoFabricanteAntes,
            produtoQuantidadeAntes = :produtoQuantidadeAntes,
            produtoUnidadeMedidaAntes = :produtoUnidadeMedidaAntes,
            produtoQuantidadeCaixaAntes = :produtoQuantidadeCaixaAntes,
            produtoLocalAntes = :produtoLocalAntes,
            produtoPosicaoAntes = :produtoPosicaoAntes,
            produtoCondicaoNovoAntes = :produtoCondicaoNovoAntes,
            produtoCondicaoUsadoAntes = :produtoCondicaoUsadoAntes,
            produtoCondicaoAbertoAntes = :produtoCondicaoAbertoAntes,
            produtoCondicaoSemCaixaAntes = :produtoCondicaoSemCaixaAntes,
            produtoCondicaoReparadoAntes = :produtoCondicaoReparadoAntes,
            produtoCondicaoSemReparoAntes = :produtoCondicaoSemReparoAntes,
            produtoObservacaoAntes = :produtoObservacaoAntes,
            produtoValorEstoqueAntes = :produtoValorEstoqueAntes,
            produtoValorRealAntes = :produtoValorRealAntes,
            produtoUltimaAtualizacaoAntes = :produtoUltimaAtualizacaoAntes,
            produtoLinkMLAntes = :produtoLinkMLAntes,

            produtoCodigoDepois = :produtoCodigoDepois,
            produtoCategoriaDepois = :produtoCategoriaDepois,
            produtoDescricaoDepois = :produtoDescricaoDepois,
            produtoFabricanteDepois = :produtoFabricanteDepois,
            produtoQuantidadeDepois = :produtoQuantidadeDepois,
            produtoUnidadeMedidaDepois = :produtoUnidadeMedidaDepois,
            produtoQuantidadeCaixaDepois = :produtoQuantidadeCaixaDepois,
            produtoLocalDepois = :produtoLocalDepois,
            produtoPosicaoDepois = :produtoPosicaoDepois,
            produtoCondicaoNovoDepois = :produtoCondicaoNovoDepois,
            produtoCondicaoUsadoDepois = :produtoCondicaoUsadoDepois,
            produtoCondicaoAbertoDepois = :produtoCondicaoAbertoDepois,
            produtoCondicaoSemCaixaDepois = :produtoCondicaoSemCaixaDepois,
            produtoCondicaoReparadoDepois = :produtoCondicaoReparadoDepois,
            produtoCondicaoSemReparoDepois = :produtoCondicaoSemReparoDepois,
            produtoObservacaoDepois = :produtoObservacaoDepois,
            produtoValorEstoqueDepois = :produtoValorEstoqueDepois,
            produtoValorRealDepois = :produtoValorRealDepois,
            produtoUltimaAtualizacaoDepois = :produtoUltimaAtualizacaoDepois,
            produtoLinkMLDepois = :produtoLinkMLDepois';


    // PREPARE STATEMENTE
    $stmt = $this->conn->prepare($query);

    // CLEAN DATA
    $this->data = htmlspecialchars(strip_tags($this->data));
    $this->editadoPor = htmlspecialchars(strip_tags($this->editadoPor));
    
    $this->produtoCodigoAntes = htmlspecialchars(strip_tags($this->produtoCodigoAntes));
    $this->produtoCategoriaAntes = htmlspecialchars(strip_tags($this->produtoCategoriaAntes));
    $this->produtoDescricaoAntes = htmlspecialchars(strip_tags($this->produtoDescricaoAntes));
    $this->produtoFabricanteAntes = htmlspecialchars(strip_tags($this->produtoFabricanteAntes));
    $this->produtoQuantidadeAntes = htmlspecialchars(strip_tags($this->produtoQuantidadeAntes));
    $this->produtoUnidadeMedidaAntes = htmlspecialchars(strip_tags($this->produtoUnidadeMedidaAntes));
    $this->produtoQuantidadeCaixaAntes = htmlspecialchars(strip_tags($this->produtoQuantidadeCaixaAntes));
    $this->produtoLocalAntes = htmlspecialchars(strip_tags($this->produtoLocalAntes));
    $this->produtoPosicaoAntes = htmlspecialchars(strip_tags($this->produtoPosicaoAntes));
    $this->produtoCondicaoNovoAntes = htmlspecialchars(strip_tags($this->produtoCondicaoNovoAntes));
    $this->produtoCondicaoUsadoAntes = htmlspecialchars(strip_tags($this->produtoCondicaoUsadoAntes));
    $this->produtoCondicaoAbertoAntes = htmlspecialchars(strip_tags($this->produtoCondicaoAbertoAntes));
    $this->produtoCondicaoSemCaixaAntes = htmlspecialchars(strip_tags($this->produtoCondicaoSemCaixaAntes));
    $this->produtoCondicaoReparadoAntes = htmlspecialchars(strip_tags($this->produtoCondicaoReparadoAntes));
    $this->produtoCondicaoSemReparoAntes = htmlspecialchars(strip_tags($this->produtoCondicaoSemReparoAntes));
    $this->produtoObservacaoAntes = htmlspecialchars(strip_tags($this->produtoObservacaoAntes));
    $this->produtoValorEstoqueAntes = htmlspecialchars(strip_tags($this->produtoValorEstoqueAntes));
    $this->produtoValorRealAntes = htmlspecialchars(strip_tags($this->produtoValorRealAntes));
    $this->produtoLinkMLAntes = htmlspecialchars(strip_tags($this->produtoLinkMLAntes));
    $this->produtoUltimaAtualizacaoAntes = htmlspecialchars(strip_tags($this->produtoUltimaAtualizacaoAntes));

    $this->produtoCodigoDepois = htmlspecialchars(strip_tags($this->produtoCodigoDepois));
    $this->produtoCategoriaDepois = htmlspecialchars(strip_tags($this->produtoCategoriaDepois));
    $this->produtoDescricaoDepois = htmlspecialchars(strip_tags($this->produtoDescricaoDepois));
    $this->produtoFabricanteDepois = htmlspecialchars(strip_tags($this->produtoFabricanteDepois));
    $this->produtoQuantidadeDepois = htmlspecialchars(strip_tags($this->produtoQuantidadeDepois));
    $this->produtoUnidadeMedidaDepois = htmlspecialchars(strip_tags($this->produtoUnidadeMedidaDepois));
    $this->produtoQuantidadeCaixaDepois = htmlspecialchars(strip_tags($this->produtoQuantidadeCaixaDepois));
    $this->produtoLocalDepois = htmlspecialchars(strip_tags($this->produtoLocalDepois));
    $this->produtoPosicaoDepois = htmlspecialchars(strip_tags($this->produtoPosicaoDepois));
    $this->produtoCondicaoNovoDepois = htmlspecialchars(strip_tags($this->produtoCondicaoNovoDepois));
    $this->produtoCondicaoUsadoDepois = htmlspecialchars(strip_tags($this->produtoCondicaoUsadoDepois));
    $this->produtoCondicaoAbertoDepois = htmlspecialchars(strip_tags($this->produtoCondicaoAbertoDepois));
    $this->produtoCondicaoSemCaixaDepois = htmlspecialchars(strip_tags($this->produtoCondicaoSemCaixaDepois));
    $this->produtoCondicaoReparadoDepois = htmlspecialchars(strip_tags($this->produtoCondicaoReparadoDepois));
    $this->produtoCondicaoSemReparoDepois = htmlspecialchars(strip_tags($this->produtoCondicaoSemReparoDepois));
    $this->produtoObservacaoDepois = htmlspecialchars(strip_tags($this->produtoObservacaoDepois));
    $this->produtoValorEstoqueDepois = htmlspecialchars(strip_tags($this->produtoValorEstoqueDepois));
    $this->produtoValorRealDepois = htmlspecialchars(strip_tags($this->produtoValorRealDepois));
    $this->produtoLinkMLDepois = htmlspecialchars(strip_tags($this->produtoLinkMLDepois));
    $this->produtoUltimaAtualizacaoDepois = htmlspecialchars(strip_tags($this->produtoUltimaAtualizacaoDepois));
    
    // BIND DATA
    $stmt->bindParam(':data', $this->data);
    $stmt->bindParam(':editadoPor', $this->editadoPor);
    
     $stmt->bindParam(':produtoCodigoAntes', $this->produtoCodigoAntes);
    $stmt->bindParam(':produtoCategoriaAntes', $this->produtoCategoriaAntes);
    $stmt->bindParam(':produtoDescricaoAntes', $this->produtoDescricaoAntes);
    $stmt->bindParam(':produtoFabricanteAntes', $this->produtoFabricanteAntes);
    $stmt->bindParam(':produtoQuantidadeAntes', $this->produtoQuantidadeAntes);
    $stmt->bindParam(':produtoUnidadeMedidaAntes', $this->produtoUnidadeMedidaAntes);
    $stmt->bindParam(':produtoQuantidadeCaixaAntes', $this->produtoQuantidadeCaixaAntes);
    $stmt->bindParam(':produtoLocalAntes', $this->produtoLocalAntes);
    $stmt->bindParam(':produtoPosicaoAntes', $this->produtoPosicaoAntes);
    $stmt->bindParam(':produtoCondicaoNovoAntes', $this->produtoCondicaoNovoAntes);
    $stmt->bindParam(':produtoCondicaoUsadoAntes', $this->produtoCondicaoUsadoAntes);
    $stmt->bindParam(':produtoCondicaoAbertoAntes', $this->produtoCondicaoAbertoAntes);
    $stmt->bindParam(':produtoCondicaoSemCaixaAntes', $this->produtoCondicaoSemCaixaAntes);
    $stmt->bindParam(':produtoCondicaoReparadoAntes', $this->produtoCondicaoReparadoAntes);
    $stmt->bindParam(':produtoCondicaoSemReparoAntes', $this->produtoCondicaoSemReparoAntes);
    $stmt->bindParam(':produtoObservacaoAntes', $this->produtoObservacaoAntes);
    $stmt->bindParam(':produtoValorEstoqueAntes', $this->produtoValorEstoqueAntes);
    $stmt->bindParam(':produtoValorRealAntes', $this->produtoValorRealAntes);
    $stmt->bindParam(':produtoLinkMLAntes', $this->produtoLinkMLAntes);
    $stmt->bindParam(':produtoUltimaAtualizacaoAntes', $this->produtoUltimaAtualizacaoAntes);
    
    $stmt->bindParam(':produtoCodigoDepois', $this->produtoCodigoDepois);
    $stmt->bindParam(':produtoCategoriaDepois', $this->produtoCategoriaDepois);
    $stmt->bindParam(':produtoDescricaoDepois', $this->produtoDescricaoDepois);
    $stmt->bindParam(':produtoFabricanteDepois', $this->produtoFabricanteDepois);
    $stmt->bindParam(':produtoQuantidadeDepois', $this->produtoQuantidadeDepois);
    $stmt->bindParam(':produtoUnidadeMedidaDepois', $this->produtoUnidadeMedidaDepois);
    $stmt->bindParam(':produtoQuantidadeCaixaDepois', $this->produtoQuantidadeCaixaDepois);
    $stmt->bindParam(':produtoLocalDepois', $this->produtoLocalDepois);
    $stmt->bindParam(':produtoPosicaoDepois', $this->produtoPosicaoDepois);
    $stmt->bindParam(':produtoCondicaoNovoDepois', $this->produtoCondicaoNovoDepois);
    $stmt->bindParam(':produtoCondicaoUsadoDepois', $this->produtoCondicaoUsadoDepois);
    $stmt->bindParam(':produtoCondicaoAbertoDepois', $this->produtoCondicaoAbertoDepois);
    $stmt->bindParam(':produtoCondicaoSemCaixaDepois', $this->produtoCondicaoSemCaixaDepois);
    $stmt->bindParam(':produtoCondicaoReparadoDepois', $this->produtoCondicaoReparadoDepois);
    $stmt->bindParam(':produtoCondicaoSemReparoDepois', $this->produtoCondicaoSemReparoDepois);
    $stmt->bindParam(':produtoObservacaoDepois', $this->produtoObservacaoDepois);
    $stmt->bindParam(':produtoValorEstoqueDepois', $this->produtoValorEstoqueDepois);
    $stmt->bindParam(':produtoValorRealDepois', $this->produtoValorRealDepois);
    $stmt->bindParam(':produtoLinkMLDepois', $this->produtoLinkMLDepois);
    $stmt->bindParam(':produtoUltimaAtualizacaoDepois', $this->produtoUltimaAtualizacaoDepois);

    // EXECUTE QUERY
    if($stmt->execute()){
        return true;
    }

    // PRINT ERROR IF SOMETHING GOES WRONG
    printf("Error: %s.\n",$stmt->error);

        return false;
    }

    // UPDATE POST
    public function update(){
    
        // CREATE QUERY
        $query= 'UPDATE ' . $this->table . '
            SET
                data = :data,
            editadoPor = :editadoPor,
            
            produtoCodigoAntes = :produtoCodigoAntes,
            produtoCategoriaAntes = :produtoCategoriaAntes,
            produtoDescricaoAntes = :produtoDescricaoAntes,
            produtoFabricanteAntes = :produtoFabricanteAntes,
            produtoQuantidadeAntes = :produtoQuantidadeAntes,
            produtoUnidadeMedidaAntes = :produtoUnidadeMedidaAntes,
            produtoQuantidadeCaixaAntes = :produtoQuantidadeCaixaAntes,
            produtoLocalAntes = :produtoLocalAntes,
            produtoPosicaoAntes = :produtoPosicaoAntes,
            produtoCondicaoNovoAntes = :produtoCondicaoNovoAntes,
            produtoCondicaoUsadoAntes = :produtoCondicaoUsadoAntes,
            produtoCondicaoAbertoAntes = :produtoCondicaoAbertoAntes,
            produtoCondicaoSemCaixaAntes = :produtoCondicaoSemCaixaAntes,
            produtoCondicaoReparadoAntes = :produtoCondicaoReparadoAntes,
            produtoCondicaoSemReparoAntes = :produtoCondicaoSemReparoAntes,
            produtoObservacaoAntes = :produtoObservacaoAntes,
            produtoValorEstoqueAntes = :produtoValorEstoqueAntes,
            produtoValorRealAntes = :produtoValorRealAntes,
            produtoUltimaAtualizacaoAntes = :produtoUltimaAtualizacaoAntes,
            produtoLinkMLAntes = :produtoLinkMLAntes,

            produtoCodigoDepois = :produtoCodigoDepois,
            produtoCategoriaDepois = :produtoCategoriaDepois,
            produtoDescricaoDepois = :produtoDescricaoDepois,
            produtoFabricanteDepois = :produtoFabricanteDepois,
            produtoQuantidadeDepois = :produtoQuantidadeDepois,
            produtoUnidadeMedidaDepois = :produtoUnidadeMedidaDepois,
            produtoQuantidadeCaixaDepois = :produtoQuantidadeCaixaDepois,
            produtoLocalDepois = :produtoLocalDepois,
            produtoPosicaoDepois = :produtoPosicaoDepois,
            produtoCondicaoNovoDepois = :produtoCondicaoNovoDepois,
            produtoCondicaoUsadoDepois = :produtoCondicaoUsadoDepois,
            produtoCondicaoAbertoDepois = :produtoCondicaoAbertoDepois,
            produtoCondicaoSemCaixaDepois = :produtoCondicaoSemCaixaDepois,
            produtoCondicaoReparadoDepois = :produtoCondicaoReparadoDepois,
            produtoCondicaoSemReparoDepois = :produtoCondicaoSemReparoDepois,
            produtoObservacaoDepois = :produtoObservacaoDepois,
            produtoValorEstoqueDepois = :produtoValorEstoqueDepois,
            produtoValorRealDepois = :produtoValorRealDepois,
            produtoUltimaAtualizacaoDepois = :produtoUltimaAtualizacaoDepois,
            produtoLinkMLDepois = :produtoLinkMLDepois
            WHERE
                id = :id';
    
        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);
    
        // CLEAN DATA
    $this->id = htmlspecialchars(strip_tags($this->id));
    $this->data = htmlspecialchars(strip_tags($this->data));
    $this->editadoPor = htmlspecialchars(strip_tags($this->editadoPor));
    
    $this->produtoCodigoAntes = htmlspecialchars(strip_tags($this->produtoCodigoAntes));
    $this->produtoCategoriaAntes = htmlspecialchars(strip_tags($this->produtoCategoriaAntes));
    $this->produtoDescricaoAntes = htmlspecialchars(strip_tags($this->produtoDescricaoAntes));
    $this->produtoFabricanteAntes = htmlspecialchars(strip_tags($this->produtoFabricanteAntes));
    $this->produtoQuantidadeAntes = htmlspecialchars(strip_tags($this->produtoQuantidadeAntes));
    $this->produtoUnidadeMedidaAntes = htmlspecialchars(strip_tags($this->produtoUnidadeMedidaAntes));
    $this->produtoQuantidadeCaixaAntes = htmlspecialchars(strip_tags($this->produtoQuantidadeCaixaAntes));
    $this->produtoLocalAntes = htmlspecialchars(strip_tags($this->produtoLocalAntes));
    $this->produtoPosicaoAntes = htmlspecialchars(strip_tags($this->produtoPosicaoAntes));
    $this->produtoCondicaoNovoAntes = htmlspecialchars(strip_tags($this->produtoCondicaoNovoAntes));
    $this->produtoCondicaoUsadoAntes = htmlspecialchars(strip_tags($this->produtoCondicaoUsadoAntes));
    $this->produtoCondicaoAbertoAntes = htmlspecialchars(strip_tags($this->produtoCondicaoAbertoAntes));
    $this->produtoCondicaoSemCaixaAntes = htmlspecialchars(strip_tags($this->produtoCondicaoSemCaixaAntes));
    $this->produtoCondicaoReparadoAntes = htmlspecialchars(strip_tags($this->produtoCondicaoReparadoAntes));
    $this->produtoCondicaoSemReparoAntes = htmlspecialchars(strip_tags($this->produtoCondicaoSemReparoAntes));
    $this->produtoObservacaoAntes = htmlspecialchars(strip_tags($this->produtoObservacaoAntes));
    $this->produtoValorEstoqueAntes = htmlspecialchars(strip_tags($this->produtoValorEstoqueAntes));
    $this->produtoValorRealAntes = htmlspecialchars(strip_tags($this->produtoValorRealAntes));
    $this->produtoLinkMLAntes = htmlspecialchars(strip_tags($this->produtoLinkMLAntes));
    $this->produtoUltimaAtualizacaoAntes = htmlspecialchars(strip_tags($this->produtoUltimaAtualizacaoAntes));

    $this->produtoCodigoDepois = htmlspecialchars(strip_tags($this->produtoCodigoDepois));
    $this->produtoCategoriaDepois = htmlspecialchars(strip_tags($this->produtoCategoriaDepois));
    $this->produtoDescricaoDepois = htmlspecialchars(strip_tags($this->produtoDescricaoDepois));
    $this->produtoFabricanteDepois = htmlspecialchars(strip_tags($this->produtoFabricanteDepois));
    $this->produtoQuantidadeDepois = htmlspecialchars(strip_tags($this->produtoQuantidadeDepois));
    $this->produtoUnidadeMedidaDepois = htmlspecialchars(strip_tags($this->produtoUnidadeMedidaDepois));
    $this->produtoQuantidadeCaixaDepois = htmlspecialchars(strip_tags($this->produtoQuantidadeCaixaDepois));
    $this->produtoLocalDepois = htmlspecialchars(strip_tags($this->produtoLocalDepois));
    $this->produtoPosicaoDepois = htmlspecialchars(strip_tags($this->produtoPosicaoDepois));
    $this->produtoCondicaoNovoDepois = htmlspecialchars(strip_tags($this->produtoCondicaoNovoDepois));
    $this->produtoCondicaoUsadoDepois = htmlspecialchars(strip_tags($this->produtoCondicaoUsadoDepois));
    $this->produtoCondicaoAbertoDepois = htmlspecialchars(strip_tags($this->produtoCondicaoAbertoDepois));
    $this->produtoCondicaoSemCaixaDepois = htmlspecialchars(strip_tags($this->produtoCondicaoSemCaixaDepois));
    $this->produtoCondicaoReparadoDepois = htmlspecialchars(strip_tags($this->produtoCondicaoReparadoDepois));
    $this->produtoCondicaoSemReparoDepois = htmlspecialchars(strip_tags($this->produtoCondicaoSemReparoDepois));
    $this->produtoObservacaoDepois = htmlspecialchars(strip_tags($this->produtoObservacaoDepois));
    $this->produtoValorEstoqueDepois = htmlspecialchars(strip_tags($this->produtoValorEstoqueDepois));
    $this->produtoValorRealDepois = htmlspecialchars(strip_tags($this->produtoValorRealDepois));
    $this->produtoLinkMLDepois = htmlspecialchars(strip_tags($this->produtoLinkMLDepois));
    $this->produtoUltimaAtualizacaoDepois = htmlspecialchars(strip_tags($this->produtoUltimaAtualizacaoDepois));

    // BIND DATA
    $stmt->bindParam(':id', $this->id);
    $stmt->bindParam(':data', $this->data);
    $stmt->bindParam(':editadoPor', $this->editadoPor);
    
     $stmt->bindParam(':produtoCodigoAntes', $this->produtoCodigoAntes);
    $stmt->bindParam(':produtoCategoriaAntes', $this->produtoCategoriaAntes);
    $stmt->bindParam(':produtoDescricaoAntes', $this->produtoDescricaoAntes);
    $stmt->bindParam(':produtoFabricanteAntes', $this->produtoFabricanteAntes);
    $stmt->bindParam(':produtoQuantidadeAntes', $this->produtoQuantidadeAntes);
    $stmt->bindParam(':produtoUnidadeMedidaAntes', $this->produtoUnidadeMedidaAntes);
    $stmt->bindParam(':produtoQuantidadeCaixaAntes', $this->produtoQuantidadeCaixaAntes);
    $stmt->bindParam(':produtoLocalAntes', $this->produtoLocalAntes);
    $stmt->bindParam(':produtoPosicaoAntes', $this->produtoPosicaoAntes);
    $stmt->bindParam(':produtoCondicaoNovoAntes', $this->produtoCondicaoNovoAntes);
    $stmt->bindParam(':produtoCondicaoUsadoAntes', $this->produtoCondicaoUsadoAntes);
    $stmt->bindParam(':produtoCondicaoAbertoAntes', $this->produtoCondicaoAbertoAntes);
    $stmt->bindParam(':produtoCondicaoSemCaixaAntes', $this->produtoCondicaoSemCaixaAntes);
    $stmt->bindParam(':produtoCondicaoReparadoAntes', $this->produtoCondicaoReparadoAntes);
    $stmt->bindParam(':produtoCondicaoSemReparoAntes', $this->produtoCondicaoSemReparoAntes);
    $stmt->bindParam(':produtoObservacaoAntes', $this->produtoObservacaoAntes);
    $stmt->bindParam(':produtoValorEstoqueAntes', $this->produtoValorEstoqueAntes);
    $stmt->bindParam(':produtoValorRealAntes', $this->produtoValorRealAntes);
    $stmt->bindParam(':produtoLinkMLAntes', $this->produtoLinkMLAntes);
    $stmt->bindParam(':produtoUltimaAtualizacaoAntes', $this->produtoUltimaAtualizacaoAntes);
    
    $stmt->bindParam(':produtoCodigoDepois', $this->produtoCodigoDepois);
    $stmt->bindParam(':produtoCategoriaDepois', $this->produtoCategoriaDepois);
    $stmt->bindParam(':produtoDescricaoDepois', $this->produtoDescricaoDepois);
    $stmt->bindParam(':produtoFabricanteDepois', $this->produtoFabricanteDepois);
    $stmt->bindParam(':produtoQuantidadeDepois', $this->produtoQuantidadeDepois);
    $stmt->bindParam(':produtoUnidadeMedidaDepois', $this->produtoUnidadeMedidaDepois);
    $stmt->bindParam(':produtoQuantidadeCaixaDepois', $this->produtoQuantidadeCaixaDepois);
    $stmt->bindParam(':produtoLocalDepois', $this->produtoLocalDepois);
    $stmt->bindParam(':produtoPosicaoDepois', $this->produtoPosicaoDepois);
    $stmt->bindParam(':produtoCondicaoNovoDepois', $this->produtoCondicaoNovoDepois);
    $stmt->bindParam(':produtoCondicaoUsadoDepois', $this->produtoCondicaoUsadoDepois);
    $stmt->bindParam(':produtoCondicaoAbertoDepois', $this->produtoCondicaoAbertoDepois);
    $stmt->bindParam(':produtoCondicaoSemCaixaDepois', $this->produtoCondicaoSemCaixaDepois);
    $stmt->bindParam(':produtoCondicaoReparadoDepois', $this->produtoCondicaoReparadoDepois);
    $stmt->bindParam(':produtoCondicaoSemReparoDepois', $this->produtoCondicaoSemReparoDepois);
    $stmt->bindParam(':produtoObservacaoDepois', $this->produtoObservacaoDepois);
    $stmt->bindParam(':produtoValorEstoqueDepois', $this->produtoValorEstoqueDepois);
    $stmt->bindParam(':produtoValorRealDepois', $this->produtoValorRealDepois);
    $stmt->bindParam(':produtoLinkMLDepois', $this->produtoLinkMLDepois);
    $stmt->bindParam(':produtoUltimaAtualizacaoDepois', $this->produtoUltimaAtualizacaoDepois);
    
        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;
        }

    // DELETE POST
    public function delete(){
        
        // CREATE QUERY
        $query = 'DELETE FROM '. $this->table . ' WHERE id = :id';

        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);

        // CLEAN DATA
        $this->id = htmlspecialchars(strip_tags($this->id));

        // BIND DATA
        $stmt->bindParam(':id', $this->id);

        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;           
        }
}