<?php

Class Movimentacao{
    // DB STUFF
    private $conn;
    private $table = 'listaMovimentacao';

    // POST PROPERTIES
    public $id;
    public $movimentacaoTipo;
    public $movimentacaoResponsavel;
    public $movimentacaoDD;
    public $movimentacaoOS;
    public $movimentacaoDescricao;
    public $movimentacaoObservacao;
    public $movimentacaoData;
    public $movimentacaoidProduto;
    public $movimentacaoQuantidadeProduto;
    public $movimentacaoFilter;
    public $movimentacaoSaldoEstoque;
    public $movimentacaoUnidadeCliente;
    public $movimentacaoNomeCliente;
    public $movimentacaoAtendimento;
    public $movimentacaoTeste;
    public $movimentacaoEmprestimo;
    public $movimentacaoStatus;

    // CONSTRUCTOR WITH DB
    public function __construct($db){
        $this->conn = $db;
    }
    
    // GET POST
    public function read(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.movimentacaoTipo,
            p.movimentacaoResponsavel,
            p.movimentacaoDD,
            p.movimentacaoOS,
            p.movimentacaoDescricao,
            p.movimentacaoObservacao,
            p.movimentacaoData,
            p.movimentacaoidProduto,            
            p.movimentacaoQuantidadeProduto,
            p.movimentacaoFilter,
            p.movimentacaoUnidadeCliente,
            p.movimentacaoNomeCliente,
            p.movimentacaoAtendimento,
            p.movimentacaoTeste,
            p.movimentacaoEmprestimo,
            p.movimentacaoStatus,
            p.movimentacaoSaldoEstoque
        FROM
            ' . $this->table . ' p
        ORDER BY
            p.id ASC';
    
    // PREPARE STATEMENT
    $stmt = $this->conn->prepare($query);

    // EXECUTE QUERY
    $stmt->execute();
    
    return $stmt;
    }

    // GET SINGLE POST
    public function read_single(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.movimentacaoTipo,
            p.movimentacaoResponsavel,
            p.movimentacaoDD,
            p.movimentacaoOS,
            p.movimentacaoDescricao,
            p.movimentacaoObservacao,
            p.movimentacaoData,
            p.movimentacaoidProduto,            
            p.movimentacaoQuantidadeProduto,
            p.movimentacaoFilter,
            p.movimentacaoUnidadeCliente,
            p.movimentacaoNomeCliente,
            p.movimentacaoAtendimento,
            p.movimentacaoTeste,
            p.movimentacaoEmprestimo,
            p.movimentacaoStatus,
            p.movimentacaoSaldoEstoque
        FROM
            ' . $this->table . ' p
        WHERE
            p.id = ?
        LIMIT 0,1';

        // PREPARE STATEMENT
        $stmt = $this->conn->prepare($query);

        // BIND ID
        $stmt->bindParam(1, $this->id);

        // EXECUTE QUERY
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        // SET PROPERTIES
        $this->movimentacaoTipo = $row['movimentacaoTipo'];
        $this->movimentacaoResponsavel = $row['movimentacaoResponsavel'];
        $this->movimentacaoDD = $row['movimentacaoDD'];
        $this->movimentacaoOS = $row['movimentacaoOS'];
        $this->movimentacaoDescricao = $row['movimentacaoDescricao'];
        $this->movimentacaoObservacao = $row['movimentacaoObservacao'];
        $this->movimentacaoData = $row['movimentacaoData'];
        $this->movimentacaoidProduto = $row['movimentacaoidProduto'];
        $this->movimentacaoQuantidadeProduto = $row['movimentacaoQuantidadeProduto'];
        $this->movimentacaoFilter = $row['movimentacaoFilter'];
        $this->movimentacaoSaldoEstoque = $row['movimentacaoSaldoEstoque'];
        $this->movimentacaoUnidadeCliente = $row['movimentacaoUnidadeCliente'];
        $this->movimentacaoNomeCliente = $row['movimentacaoNomeCliente'];
        $this->movimentacaoAtendimento = $row['movimentacaoAtendimento'];
        $this->movimentacaoStatus = $row['movimentacaoStatus'];
        $this->movimentacaoTeste = $row['movimentacaoTeste'];
        $this->movimentacaoEmprestimo = $row['movimentacaoEmprestimo'];
    }

    // CREATE POST
    public function create(){
    
    // CREATE QUERY
    $query= 'INSERT INTO ' . $this->table . '
        SET
            movimentacaoTipo = :movimentacaoTipo,
            movimentacaoResponsavel = :movimentacaoResponsavel,
            movimentacaoDD = :movimentacaoDD,
            movimentacaoOS = :movimentacaoOS,
            movimentacaoDescricao = :movimentacaoDescricao,
            movimentacaoObservacao = :movimentacaoObservacao,
            movimentacaoData = :movimentacaoData,
            movimentacaoidProduto = :movimentacaoidProduto,
            movimentacaoQuantidadeProduto = :movimentacaoQuantidadeProduto,
            movimentacaoFilter = :movimentacaoFilter,
            movimentacaoUnidadeCliente = :movimentacaoUnidadeCliente,
            movimentacaoNomeCliente = :movimentacaoNomeCliente,
            movimentacaoAtendimento = :movimentacaoAtendimento,
            movimentacaoTeste = :movimentacaoTeste,
            movimentacaoEmprestimo = :movimentacaoEmprestimo,
            movimentacaoStatus = :movimentacaoStatus,
            movimentacaoSaldoEstoque = :movimentacaoSaldoEstoque';

    // PREPARE STATEMENTE
    $stmt = $this->conn->prepare($query);

    // CLEAN DATA
    $this->movimentacaoTipo = htmlspecialchars(strip_tags($this->movimentacaoTipo));
    $this->movimentacaoResponsavel = htmlspecialchars(strip_tags($this->movimentacaoResponsavel));
    $this->movimentacaoDD = htmlspecialchars(strip_tags($this->movimentacaoDD));
    $this->movimentacaoOS = htmlspecialchars(strip_tags($this->movimentacaoOS));
    $this->movimentacaoDescricao = htmlspecialchars(strip_tags($this->movimentacaoDescricao));
    $this->movimentacaoObservacao = htmlspecialchars(strip_tags($this->movimentacaoObservacao));
    $this->movimentacaoData = htmlspecialchars(strip_tags($this->movimentacaoData));
    $this->movimentacaoidProduto = htmlspecialchars(strip_tags($this->movimentacaoidProduto));
    $this->movimentacaoQuantidadeProduto = htmlspecialchars(strip_tags($this->movimentacaoQuantidadeProduto));
    $this->movimentacaoFilter = htmlspecialchars(strip_tags($this->movimentacaoFilter));
    $this->movimentacaoSaldoEstoque = htmlspecialchars(strip_tags($this->movimentacaoSaldoEstoque));
    $this->movimentacaoUnidadeCliente = htmlspecialchars(strip_tags($this->movimentacaoUnidadeCliente));
    $this->movimentacaoNomeCliente = htmlspecialchars(strip_tags($this->movimentacaoNomeCliente));
    $this->movimentacaoAtendimento = htmlspecialchars(strip_tags($this->movimentacaoAtendimento));
    $this->movimentacaoStatus = htmlspecialchars(strip_tags($this->movimentacaoStatus));
    $this->movimentacaoTeste = htmlspecialchars(strip_tags($this->movimentacaoTeste));
    $this->movimentacaoEmprestimo = htmlspecialchars(strip_tags($this->movimentacaoEmprestimo));


    // BIND DATA
    $stmt->bindParam(':movimentacaoTipo', $this->movimentacaoTipo);
    $stmt->bindParam(':movimentacaoResponsavel', $this->movimentacaoResponsavel);
    $stmt->bindParam(':movimentacaoDD', $this->movimentacaoDD);
    $stmt->bindParam(':movimentacaoOS', $this->movimentacaoOS);
    $stmt->bindParam(':movimentacaoDescricao', $this->movimentacaoDescricao);
    $stmt->bindParam(':movimentacaoObservacao', $this->movimentacaoObservacao);
    $stmt->bindParam(':movimentacaoData', $this->movimentacaoData);
    $stmt->bindParam(':movimentacaoidProduto', $this->movimentacaoidProduto);
    $stmt->bindParam(':movimentacaoQuantidadeProduto', $this->movimentacaoQuantidadeProduto);
    $stmt->bindParam(':movimentacaoFilter', $this->movimentacaoFilter);
    $stmt->bindParam(':movimentacaoSaldoEstoque', $this->movimentacaoSaldoEstoque);
    $stmt->bindParam(':movimentacaoUnidadeCliente', $this->movimentacaoUnidadeCliente);
    $stmt->bindParam(':movimentacaoNomeCliente', $this->movimentacaoNomeCliente);
    $stmt->bindParam(':movimentacaoAtendimento', $this->movimentacaoAtendimento);
    $stmt->bindParam(':movimentacaoStatus', $this->movimentacaoStatus);
    $stmt->bindParam(':movimentacaoTeste', $this->movimentacaoTeste);
    $stmt->bindParam(':movimentacaoEmprestimo', $this->movimentacaoEmprestimo);

    // EXECUTE QUERY
    if($stmt->execute()){
        return true;
    }

    // PRINT ERROR IF SOMETHING GOES WRONG
    printf("Error: %s.\n",$stmt->error);

        return false;
    }

    // UPDATE POST
    public function update(){
    
        // CREATE QUERY
        $query= 'UPDATE ' . $this->table . '
            SET
                movimentacaoTipo = :movimentacaoTipo,
                movimentacaoResponsavel = :movimentacaoResponsavel,
                movimentacaoDD = :movimentacaoDD,
                movimentacaoOS = :movimentacaoOS,
                movimentacaoDescricao = :movimentacaoDescricao,
                movimentacaoObservacao = :movimentacaoObservacao,
                movimentacaoData = :movimentacaoData,
                movimentacaoidProduto = :movimentacaoidProduto,
                movimentacaoQuantidadeProduto = :movimentacaoQuantidadeProduto,
                movimentacaoFilter = :movimentacaoFilter,
                movimentacaoUnidadeCliente = :movimentacaoUnidadeCliente,
                movimentacaoNomeCliente = :movimentacaoNomeCliente,
                movimentacaoAtendimento = :movimentacaoAtendimento,
                movimentacaoTeste = :movimentacaoTeste,
                movimentacaoEmprestimo = :movimentacaoEmprestimo,
                movimentacaoStatus = :movimentacaoStatus,
                movimentacaoSaldoEstoque = :movimentacaoSaldoEstoque
            WHERE
                id = :id';
    
        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);
    
        // CLEAN DATA
    $this->id = htmlspecialchars(strip_tags($this->id));
    $this->movimentacaoTipo = htmlspecialchars(strip_tags($this->movimentacaoTipo));
    $this->movimentacaoResponsavel = htmlspecialchars(strip_tags($this->movimentacaoResponsavel));
    $this->movimentacaoDD = htmlspecialchars(strip_tags($this->movimentacaoDD));
    $this->movimentacaoOS = htmlspecialchars(strip_tags($this->movimentacaoOS));
    $this->movimentacaoDescricao = htmlspecialchars(strip_tags($this->movimentacaoDescricao));
    $this->movimentacaoObservacao = htmlspecialchars(strip_tags($this->movimentacaoObservacao));
    $this->movimentacaoData = htmlspecialchars(strip_tags($this->movimentacaoData));
    $this->movimentacaoidProduto = htmlspecialchars(strip_tags($this->movimentacaoidProduto));
    $this->movimentacaoQuantidadeProduto = htmlspecialchars(strip_tags($this->movimentacaoQuantidadeProduto));
    $this->movimentacaoFilter = htmlspecialchars(strip_tags($this->movimentacaoFilter));
    $this->movimentacaoSaldoEstoque = htmlspecialchars(strip_tags($this->movimentacaoSaldoEstoque));
    $this->movimentacaoUnidadeCliente = htmlspecialchars(strip_tags($this->movimentacaoUnidadeCliente));
    $this->movimentacaoNomeCliente = htmlspecialchars(strip_tags($this->movimentacaoNomeCliente));
    $this->movimentacaoAtendimento = htmlspecialchars(strip_tags($this->movimentacaoAtendimento));
    $this->movimentacaoStatus = htmlspecialchars(strip_tags($this->movimentacaoStatus));
    $this->movimentacaoTeste = htmlspecialchars(strip_tags($this->movimentacaoTeste));
    $this->movimentacaoEmprestimo = htmlspecialchars(strip_tags($this->movimentacaoEmprestimo));


    // BIND DATA
    $stmt->bindParam(':id', $this->id);
    $stmt->bindParam(':movimentacaoTipo', $this->movimentacaoTipo);
    $stmt->bindParam(':movimentacaoResponsavel', $this->movimentacaoResponsavel);
    $stmt->bindParam(':movimentacaoDD', $this->movimentacaoDD);
    $stmt->bindParam(':movimentacaoOS', $this->movimentacaoOS);
    $stmt->bindParam(':movimentacaoDescricao', $this->movimentacaoDescricao);
    $stmt->bindParam(':movimentacaoObservacao', $this->movimentacaoObservacao);
    $stmt->bindParam(':movimentacaoData', $this->movimentacaoData);
    $stmt->bindParam(':movimentacaoidProduto', $this->movimentacaoidProduto);
    $stmt->bindParam(':movimentacaoQuantidadeProduto', $this->movimentacaoQuantidadeProduto);
    $stmt->bindParam(':movimentacaoFilter', $this->movimentacaoFilter);
    $stmt->bindParam(':movimentacaoSaldoEstoque', $this->movimentacaoSaldoEstoque);
    $stmt->bindParam(':movimentacaoUnidadeCliente', $this->movimentacaoUnidadeCliente);
    $stmt->bindParam(':movimentacaoNomeCliente', $this->movimentacaoNomeCliente);
    $stmt->bindParam(':movimentacaoAtendimento', $this->movimentacaoAtendimento);
    $stmt->bindParam(':movimentacaoStatus', $this->movimentacaoStatus);
    $stmt->bindParam(':movimentacaoTeste', $this->movimentacaoTeste);
    $stmt->bindParam(':movimentacaoEmprestimo', $this->movimentacaoEmprestimo);
    
        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;
        }

    // DELETE POST
    public function delete(){
        
        // CREATE QUERY
        $query = 'DELETE FROM '. $this->table . ' WHERE id = :id';

        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);

        // CLEAN DATA
        $this->id = htmlspecialchars(strip_tags($this->id));

        // BIND DATA
        $stmt->bindParam(':id', $this->id);

        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;           
        }
}