<?php

Class Produto{
    // DB STUFF
    private $conn;
    private $table = 'listaProdutos';

    // POST PROPERTIES
    public $id;
    public $produtoCodigo;
    public $produtoCategoria;
    public $produtoDescricao;
    public $produtoFabricante;
    public $produtoQuantidade;
    public $produtoUnidadeMedida;
    public $produtoQuantidadeCaixa;
    public $produtoLocal;
    public $produtoPosicao;
    public $produtoCondicaoNovo;
    public $produtoCondicaoUsado;
    public $produtoCondicaoAberto;
    public $produtoCondicaoSemCaixa;
    public $produtoCondicaoReparado;
    public $produtoCondicaoSemReparo;
    public $produtoObservacao;
    public $produtoValorEstoque;
    public $produtoValorReal;
    public $produtoLinkML;
    public $produtoUltimaAtualizacao;

    // CONSTRUCTOR WITH DB
    public function __construct($db){
        $this->conn = $db;
    }
    
    // GET POST
    public function read(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.produtoCodigo,
            p.produtoCategoria,
            p.produtoDescricao,
            p.produtoFabricante,
            p.produtoQuantidade,
            p.produtoUnidadeMedida,
            p.produtoQuantidadeCaixa,
            p.produtoLocal,
            p.produtoPosicao,
            p.produtoCondicaoNovo,
            p.produtoCondicaoUsado,
            p.produtoCondicaoAberto,
            p.produtoCondicaoSemCaixa,
            p.produtoCondicaoReparado,
            p.produtoCondicaoSemReparo,
            p.produtoObservacao,
            p.produtoValorEstoque,
            p.produtoValorReal,
            p.produtoLinkML,
            p.produtoUltimaAtualizacao
        FROM
            ' . $this->table . ' p
        ORDER BY
            p.id ASC';
    
    // PREPARE STATEMENT
    $stmt = $this->conn->prepare($query);

    // EXECUTE QUERY
    $stmt->execute();
    
    return $stmt;
    }

    // GET SINGLE POST
    public function read_single(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.produtoCodigo,
            p.produtoCategoria,
            p.produtoDescricao,
            p.produtoFabricante,
            p.produtoQuantidade,
            p.produtoUnidadeMedida,
            p.produtoQuantidadeCaixa,
            p.produtoLocal,
            p.produtoPosicao,
            p.produtoCondicaoNovo,
            p.produtoCondicaoUsado,
            p.produtoCondicaoAberto,
            p.produtoCondicaoSemCaixa,
            p.produtoCondicaoReparado,
            p.produtoCondicaoSemReparo,
            p.produtoObservacao,
            p.produtoValorEstoque,
            p.produtoValorReal,
            p.produtoLinkML,
            p.produtoUltimaAtualizacao
        FROM
            ' . $this->table . ' p
        WHERE
            p.id = ?
        LIMIT 0,1';

        // PREPARE STATEMENT
        $stmt = $this->conn->prepare($query);

        // BIND ID
        $stmt->bindParam(1, $this->id);

        // EXECUTE QUERY
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        // SET PROPERTIES
        $this->produtoCodigo = $row['produtoCodigo'];
        $this->produtoCategoria = $row['produtoCategoria'];
        $this->produtoDescricao = $row['produtoDescricao'];
        $this->produtoFabricante = $row['produtoFabricante'];
        $this->produtoQuantidade = $row['produtoQuantidade'];
        $this->produtoUnidadeMedida = $row['produtoUnidadeMedida'];
        $this->produtoQuantidadeCaixa = $row['produtoQuantidadeCaixa'];
        $this->produtoLocal = $row['produtoLocal'];
        $this->produtoPosicao = $row['produtoPosicao'];
        $this->produtoCondicaoNovo = $row['produtoCondicaoNovo'];
        $this->produtoCondicaoUsado = $row['produtoCondicaoUsado'];
        $this->produtoCondicaoAberto = $row['produtoCondicaoAberto'];
        $this->produtoCondicaoSemCaixa = $row['produtoCondicaoSemCaixa'];
        $this->produtoCondicaoReparado = $row['produtoCondicaoReparado'];
        $this->produtoCondicaoSemReparo = $row['produtoCondicaoSemReparo'];
        $this->produtoObservacao = $row['produtoObservacao'];
        $this->produtoValorEstoque = $row['produtoValorEstoque'];
        $this->produtoValorReal = $row['produtoValorReal'];
        $this->produtoLinkML = $row['produtoLinkML'];
        $this->produtoUltimaAtualizacao = $row['produtoUltimaAtualizacao'];
    }

    // CREATE POST
    public function create(){
    
    // CREATE QUERY
    $query= 'INSERT INTO ' . $this->table . '
        SET
            produtoCodigo = :produtoCodigo,
            produtoCategoria = :produtoCategoria,
            produtoDescricao = :produtoDescricao,
            produtoFabricante = :produtoFabricante,
            produtoQuantidade = :produtoQuantidade,
            produtoUnidadeMedida = :produtoUnidadeMedida,
            produtoQuantidadeCaixa = :produtoQuantidadeCaixa,
            produtoLocal = :produtoLocal,
            produtoPosicao = :produtoPosicao,
            produtoCondicaoNovo = :produtoCondicaoNovo,
            produtoCondicaoUsado = :produtoCondicaoUsado,
            produtoCondicaoAberto = :produtoCondicaoAberto,
            produtoCondicaoSemCaixa = :produtoCondicaoSemCaixa,
            produtoCondicaoReparado = :produtoCondicaoReparado,
            produtoCondicaoSemReparo = :produtoCondicaoSemReparo,
            produtoObservacao = :produtoObservacao,
            produtoValorEstoque = :produtoValorEstoque,
            produtoValorReal = :produtoValorReal,
            produtoUltimaAtualizacao = :produtoUltimaAtualizacao,
            produtoLinkML = :produtoLinkML';


    // PREPARE STATEMENTE
    $stmt = $this->conn->prepare($query);

    // CLEAN DATA
    $this->produtoCodigo = htmlspecialchars(strip_tags($this->produtoCodigo));
    $this->produtoCategoria = htmlspecialchars(strip_tags($this->produtoCategoria));
    $this->produtoDescricao = htmlspecialchars(strip_tags($this->produtoDescricao));
    $this->produtoFabricante = htmlspecialchars(strip_tags($this->produtoFabricante));
    $this->produtoQuantidade = htmlspecialchars(strip_tags($this->produtoQuantidade));
    $this->produtoUnidadeMedida = htmlspecialchars(strip_tags($this->produtoUnidadeMedida));
    $this->produtoQuantidadeCaixa = htmlspecialchars(strip_tags($this->produtoQuantidadeCaixa));
    $this->produtoLocal = htmlspecialchars(strip_tags($this->produtoLocal));
    $this->produtoPosicao = htmlspecialchars(strip_tags($this->produtoPosicao));
    $this->produtoCondicaoNovo = htmlspecialchars(strip_tags($this->produtoCondicaoNovo));
    $this->produtoCondicaoUsado = htmlspecialchars(strip_tags($this->produtoCondicaoUsado));
    $this->produtoCondicaoAberto = htmlspecialchars(strip_tags($this->produtoCondicaoAberto));
    $this->produtoCondicaoSemCaixa = htmlspecialchars(strip_tags($this->produtoCondicaoSemCaixa));
    $this->produtoCondicaoReparado = htmlspecialchars(strip_tags($this->produtoCondicaoReparado));
    $this->produtoCondicaoSemReparo = htmlspecialchars(strip_tags($this->produtoCondicaoSemReparo));
    $this->produtoObservacao = htmlspecialchars(strip_tags($this->produtoObservacao));
    $this->produtoValorEstoque = htmlspecialchars(strip_tags($this->produtoValorEstoque));
    $this->produtoValorReal = htmlspecialchars(strip_tags($this->produtoValorReal));
    $this->produtoLinkML = htmlspecialchars(strip_tags($this->produtoLinkML));
    $this->produtoUltimaAtualizacao = htmlspecialchars(strip_tags($this->produtoUltimaAtualizacao));

    // BIND DATA
    $stmt->bindParam(':produtoCodigo', $this->produtoCodigo);
    $stmt->bindParam(':produtoCategoria', $this->produtoCategoria);
    $stmt->bindParam(':produtoDescricao', $this->produtoDescricao);
    $stmt->bindParam(':produtoFabricante', $this->produtoFabricante);
    $stmt->bindParam(':produtoQuantidade', $this->produtoQuantidade);
    $stmt->bindParam(':produtoUnidadeMedida', $this->produtoUnidadeMedida);
    $stmt->bindParam(':produtoQuantidadeCaixa', $this->produtoQuantidadeCaixa);
    $stmt->bindParam(':produtoLocal', $this->produtoLocal);
    $stmt->bindParam(':produtoPosicao', $this->produtoPosicao);
    $stmt->bindParam(':produtoCondicaoNovo', $this->produtoCondicaoNovo);
    $stmt->bindParam(':produtoCondicaoUsado', $this->produtoCondicaoUsado);
    $stmt->bindParam(':produtoCondicaoAberto', $this->produtoCondicaoAberto);
    $stmt->bindParam(':produtoCondicaoSemCaixa', $this->produtoCondicaoSemCaixa);
    $stmt->bindParam(':produtoCondicaoReparado', $this->produtoCondicaoReparado);
    $stmt->bindParam(':produtoCondicaoSemReparo', $this->produtoCondicaoSemReparo);
    $stmt->bindParam(':produtoObservacao', $this->produtoObservacao);
    $stmt->bindParam(':produtoValorEstoque', $this->produtoValorEstoque);
    $stmt->bindParam(':produtoValorReal', $this->produtoValorReal);
    $stmt->bindParam(':produtoLinkML', $this->produtoLinkML);
    $stmt->bindParam(':produtoUltimaAtualizacao', $this->produtoUltimaAtualizacao);

    // EXECUTE QUERY
    if($stmt->execute()){
        return true;
    }

    // PRINT ERROR IF SOMETHING GOES WRONG
    printf("Error: %s.\n",$stmt->error);

        return false;
    }

    // UPDATE POST
    public function update(){
    
        // CREATE QUERY
        $query= 'UPDATE ' . $this->table . '
            SET
                produtoCodigo = :produtoCodigo,
                produtoCategoria = :produtoCategoria,
                produtoDescricao = :produtoDescricao,
                produtoFabricante = :produtoFabricante,
                produtoQuantidade = :produtoQuantidade,
                produtoUnidadeMedida = :produtoUnidadeMedida,
                produtoQuantidadeCaixa = :produtoQuantidadeCaixa,
                produtoLocal = :produtoLocal,
                produtoPosicao = :produtoPosicao,
                produtoCondicaoNovo = :produtoCondicaoNovo,
                produtoCondicaoUsado = :produtoCondicaoUsado,
                produtoCondicaoAberto = :produtoCondicaoAberto,
                produtoCondicaoSemCaixa = :produtoCondicaoSemCaixa,
                produtoCondicaoReparado = :produtoCondicaoReparado,
                produtoCondicaoSemReparo = :produtoCondicaoSemReparo,
                produtoObservacao = :produtoObservacao,
                produtoValorEstoque = :produtoValorEstoque,
                produtoValorReal = :produtoValorReal,
                produtoLinkML = :produtoLinkML,
                produtoUltimaAtualizacao = :produtoUltimaAtualizacao
            WHERE
                id = :id';
    
        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);
    
        // CLEAN DATA
    $this->id = htmlspecialchars(strip_tags($this->id));
    $this->produtoCodigo = htmlspecialchars(strip_tags($this->produtoCodigo));
    $this->produtoCategoria = htmlspecialchars(strip_tags($this->produtoCategoria));
    $this->produtoDescricao = htmlspecialchars(strip_tags($this->produtoDescricao));
    $this->produtoFabricante = htmlspecialchars(strip_tags($this->produtoFabricante));
    $this->produtoQuantidade = htmlspecialchars(strip_tags($this->produtoQuantidade));
    $this->produtoUnidadeMedida = htmlspecialchars(strip_tags($this->produtoUnidadeMedida));
    $this->produtoQuantidadeCaixa = htmlspecialchars(strip_tags($this->produtoQuantidadeCaixa));
    $this->produtoLocal = htmlspecialchars(strip_tags($this->produtoLocal));
    $this->produtoPosicao = htmlspecialchars(strip_tags($this->produtoPosicao));
    $this->produtoCondicaoNovo = htmlspecialchars(strip_tags($this->produtoCondicaoNovo));
    $this->produtoCondicaoUsado = htmlspecialchars(strip_tags($this->produtoCondicaoUsado));
    $this->produtoCondicaoAberto = htmlspecialchars(strip_tags($this->produtoCondicaoAberto));
    $this->produtoCondicaoSemCaixa = htmlspecialchars(strip_tags($this->produtoCondicaoSemCaixa));
    $this->produtoCondicaoReparado = htmlspecialchars(strip_tags($this->produtoCondicaoReparado));
    $this->produtoCondicaoSemReparo = htmlspecialchars(strip_tags($this->produtoCondicaoSemReparo));
    $this->produtoObservacao = htmlspecialchars(strip_tags($this->produtoObservacao));
    $this->produtoValorEstoque = htmlspecialchars(strip_tags($this->produtoValorEstoque));
    $this->produtoValorReal = htmlspecialchars(strip_tags($this->produtoValorReal));
    $this->produtoLinkML = htmlspecialchars(strip_tags($this->produtoLinkML));
    $this->produtoUltimaAtualizacao = htmlspecialchars(strip_tags($this->produtoUltimaAtualizacao));

    // BIND DATA
    $stmt->bindParam(':id', $this->id);
    $stmt->bindParam(':produtoCodigo', $this->produtoCodigo);
    $stmt->bindParam(':produtoCategoria', $this->produtoCategoria);
    $stmt->bindParam(':produtoDescricao', $this->produtoDescricao);
    $stmt->bindParam(':produtoFabricante', $this->produtoFabricante);
    $stmt->bindParam(':produtoQuantidade', $this->produtoQuantidade);
    $stmt->bindParam(':produtoUnidadeMedida', $this->produtoUnidadeMedida);
    $stmt->bindParam(':produtoQuantidadeCaixa', $this->produtoQuantidadeCaixa);
    $stmt->bindParam(':produtoLocal', $this->produtoLocal);
    $stmt->bindParam(':produtoPosicao', $this->produtoPosicao);
    $stmt->bindParam(':produtoCondicaoNovo', $this->produtoCondicaoNovo);
    $stmt->bindParam(':produtoCondicaoUsado', $this->produtoCondicaoUsado);
    $stmt->bindParam(':produtoCondicaoAberto', $this->produtoCondicaoAberto);
    $stmt->bindParam(':produtoCondicaoSemCaixa', $this->produtoCondicaoSemCaixa);
    $stmt->bindParam(':produtoCondicaoReparado', $this->produtoCondicaoReparado);
    $stmt->bindParam(':produtoCondicaoSemReparo', $this->produtoCondicaoSemReparo);
    $stmt->bindParam(':produtoObservacao', $this->produtoObservacao);
    $stmt->bindParam(':produtoValorEstoque', $this->produtoValorEstoque);
    $stmt->bindParam(':produtoValorReal', $this->produtoValorReal);
    $stmt->bindParam(':produtoLinkML', $this->produtoLinkML);
    $stmt->bindParam(':produtoUltimaAtualizacao', $this->produtoUltimaAtualizacao);
    
        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;
        }

    // DELETE POST
    public function delete(){
        
        // CREATE QUERY
        $query = 'DELETE FROM '. $this->table . ' WHERE id = :id';

        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);

        // CLEAN DATA
        $this->id = htmlspecialchars(strip_tags($this->id));

        // BIND DATA
        $stmt->bindParam(':id', $this->id);

        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;           
        }
}