<?php

Class RME{
    // DB STUFF
    private $conn;
    private $table = 'listaRME';

    // POST PROPERTIES
    public $id;
    public $rmeResponsavel;
    public $rmeDD;
    public $rmeOS;
    public $rmeDescricao;
    public $rmeObservacao;
    public $rmeData;
    public $rmeidProduto;
    public $rmeQuantidadeProduto;
    public $rmeFilter;
    public $rmeAutorizar;
    public $rmeCriadoPor;
    public $rmeObservacaoGeral;
    public $rmeNomeCliente;
    public $rmeUnidadeCliente;
    public $rmeAtendimento;
    public $rmeTeste;
    public $rmeEmprestimo;
    public $rmeStatus;

    // CONSTRUCTOR WITH DB
    public function __construct($db){
        $this->conn = $db;
    }
    
    // GET POST
    public function read(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.rmeResponsavel,
            p.rmeDD,
            p.rmeOS,
            p.rmeDescricao,
            p.rmeObservacao,
            p.rmeData,
            p.rmeidProduto,
            p.rmeQuantidadeProduto,
            p.rmeFilter,
            p.rmeAutorizar,
            p.rmeCriadoPor,
            p.rmeObservacaoGeral,
            p.rmeUnidadeCliente,
            p.rmeAtendimento,
            p.rmeTeste,
            p.rmeEmprestimo,
            p.rmeStatus,
            p.rmeNomeCliente
        FROM
            ' . $this->table . ' p
        ORDER BY
            p.rmeFilter ASC';
    
    // PREPARE STATEMENT
    $stmt = $this->conn->prepare($query);

    // EXECUTE QUERY
    $stmt->execute();
    
    return $stmt;
    }

    // GET SINGLE POST
    public function read_single(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.rmeResponsavel,
            p.rmeDD,
            p.rmeOS,
            p.rmeDescricao,
            p.rmeObservacao,
            p.rmeData,
            p.rmeidProduto,
            p.rmeQuantidadeProduto,
            p.rmeFilter,
            p.rmeAutorizar,
            p.rmeCriadoPor,
            p.rmeObservacaoGeral,
            p.rmeUnidadeCliente,
            p.rmeAtendimento,
            p.rmeTeste,
            p.rmeEmprestimo,
            p.rmeStatus,
            p.rmeNomeCliente
        FROM
            ' . $this->table . ' p
        WHERE
            p.id = ?
        LIMIT 0,1';

        // PREPARE STATEMENT
        $stmt = $this->conn->prepare($query);

        // BIND ID
        $stmt->bindParam(1, $this->id);

        // EXECUTE QUERY
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        // SET PROPERTIES
        $this->rmeResponsavel = $row['rmeResponsavel'];
        $this->rmeDD = $row['rmeDD'];
        $this->rmeOS = $row['rmeOS'];
        $this->rmeDescricao = $row['rmeDescricao'];
        $this->rmeObservacao = $row['rmeObservacao'];
        $this->rmeData = $row['rmeData'];
        $this->rmeidProduto = $row['rmeidProduto'];
        $this->rmeQuantidadeProduto = $row['rmeQuantidadeProduto'];
        $this->rmeFilter = $row['rmeFilter'];
        $this->rmeAutorizar = $row['rmeAutorizar'];
        $this->rmeCriadoPor = $row['rmeCriadoPor'];
        $this->rmeObservacaoGeral = $row['rmeObservacaoGeral'];
        $this->rmeUnidadeCliente = $row['rmeUnidadeCliente'];
        $this->rmeNomeCliente = $row['rmeNomeCliente'];
        $this->rmeAtendimento = $row['rmeAtendimento'];
        $this->rmeStatus = $row['rmeStatus'];
        $this->rmeTeste = $row['rmeTeste'];
        $this->rmeEmprestimo = $row['rmeEmprestimo'];
    }

    // CREATE POST
    public function create(){
    
    // CREATE QUERY
    $query= 'INSERT INTO ' . $this->table . '
        SET
            rmeResponsavel = :rmeResponsavel,
            rmeDD = :rmeDD,
            rmeOS = :rmeOS,
            rmeDescricao = :rmeDescricao,
            rmeObservacao = :rmeObservacao,
            rmeData = :rmeData,
            rmeidProduto = :rmeidProduto,
            rmeFilter = :rmeFilter,
            rmeAutorizar = :rmeAutorizar,
            rmeCriadoPor = :rmeCriadoPor,
            rmeObservacaoGeral = :rmeObservacaoGeral,
            rmeUnidadeCliente = :rmeUnidadeCliente,
            rmeNomeCliente = :rmeNomeCliente,
            rmeAtendimento = :rmeAtendimento,
            rmeTeste = :rmeTeste,
            rmeEmprestimo = :rmeEmprestimo,
            rmeStatus = :rmeStatus,
            rmeQuantidadeProduto = :rmeQuantidadeProduto';

    // PREPARE STATEMENTE
    $stmt = $this->conn->prepare($query);

    // CLEAN DATA
    $this->rmeResponsavel = htmlspecialchars(strip_tags($this->rmeResponsavel));
    $this->rmeDD = htmlspecialchars(strip_tags($this->rmeDD));
    $this->rmeOS = htmlspecialchars(strip_tags($this->rmeOS));
    $this->rmeDescricao = htmlspecialchars(strip_tags($this->rmeDescricao));
    $this->rmeObservacao = htmlspecialchars(strip_tags($this->rmeObservacao));
    $this->rmeData = htmlspecialchars(strip_tags($this->rmeData));
    $this->rmeidProduto = htmlspecialchars(strip_tags($this->rmeidProduto));
    $this->rmeQuantidadeProduto = htmlspecialchars(strip_tags($this->rmeQuantidadeProduto));
    $this->rmeFilter = htmlspecialchars(strip_tags($this->rmeFilter));
    $this->rmeAutorizar = htmlspecialchars(strip_tags($this->rmeAutorizar));
    $this->rmeCriadoPor = htmlspecialchars(strip_tags($this->rmeCriadoPor));
    $this->rmeObservacaoGeral = htmlspecialchars(strip_tags($this->rmeObservacaoGeral));
    $this->rmeUnidadeCliente = htmlspecialchars(strip_tags($this->rmeUnidadeCliente));
    $this->rmeNomeCliente = htmlspecialchars(strip_tags($this->rmeNomeCliente));
    $this->rmeAtendimento = htmlspecialchars(strip_tags($this->rmeAtendimento));
    $this->rmeStatus = htmlspecialchars(strip_tags($this->rmeStatus));
    $this->rmeTeste = htmlspecialchars(strip_tags($this->rmeTeste));
    $this->rmeEmprestimo = htmlspecialchars(strip_tags($this->rmeEmprestimo));

    // BIND DATA
    $stmt->bindParam(':rmeResponsavel', $this->rmeResponsavel);
    $stmt->bindParam(':rmeDD', $this->rmeDD);
    $stmt->bindParam(':rmeOS', $this->rmeOS);
    $stmt->bindParam(':rmeDescricao', $this->rmeDescricao);
    $stmt->bindParam(':rmeObservacao', $this->rmeObservacao);
    $stmt->bindParam(':rmeData', $this->rmeData);
    $stmt->bindParam(':rmeidProduto', $this->rmeidProduto);
    $stmt->bindParam(':rmeQuantidadeProduto', $this->rmeQuantidadeProduto);
    $stmt->bindParam(':rmeFilter', $this->rmeFilter);
    $stmt->bindParam(':rmeAutorizar', $this->rmeAutorizar);
    $stmt->bindParam(':rmeCriadoPor', $this->rmeCriadoPor);
    $stmt->bindParam(':rmeObservacaoGeral', $this->rmeObservacaoGeral);
    $stmt->bindParam(':rmeUnidadeCliente', $this->rmeUnidadeCliente);
    $stmt->bindParam(':rmeNomeCliente', $this->rmeNomeCliente);
    $stmt->bindParam(':rmeAtendimento', $this->rmeAtendimento);
    $stmt->bindParam(':rmeStatus', $this->rmeStatus);
    $stmt->bindParam(':rmeTeste', $this->rmeTeste);
    $stmt->bindParam(':rmeEmprestimo', $this->rmeEmprestimo);

    // EXECUTE QUERY
    if($stmt->execute()){
        return true;
    }

    // PRINT ERROR IF SOMETHING GOES WRONG
    printf("Error: %s.\n",$stmt->error);

        return false;
    }

    // UPDATE POST
    public function update(){
    
        // CREATE QUERY
        $query= 'UPDATE ' . $this->table . '
            SET
                rmeResponsavel = :rmeResponsavel,
                rmeDD = :rmeDD,
                rmeOS = :rmeOS,
                rmeDescricao = :rmeDescricao,
                rmeObservacao = :rmeObservacao,
                rmeData = :rmeData,
                rmeidProduto = :rmeidProduto,
                rmeFilter = :rmeFilter,
                rmeAutorizar = :rmeAutorizar,
                rmeCriadoPor = :rmeCriadoPor,
                rmeObservacaoGeral = :rmeObservacaoGeral,
                rmeUnidadeCliente = :rmeUnidadeCliente,
                rmeNomeCliente = :rmeNomeCliente,
                rmeAtendimento = :rmeAtendimento,
                rmeTeste = :rmeTeste,
                rmeEmprestimo = :rmeEmprestimo,
                rmeStatus = :rmeStatus,
                rmeQuantidadeProduto = :rmeQuantidadeProduto
            WHERE
                id = :id';
    
        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);
    
        // CLEAN DATA
    $this->id = htmlspecialchars(strip_tags($this->id));
    $this->rmeResponsavel = htmlspecialchars(strip_tags($this->rmeResponsavel));
    $this->rmeDD = htmlspecialchars(strip_tags($this->rmeDD));
    $this->rmeOS = htmlspecialchars(strip_tags($this->rmeOS));
    $this->rmeDescricao = htmlspecialchars(strip_tags($this->rmeDescricao));
    $this->rmeObservacao = htmlspecialchars(strip_tags($this->rmeObservacao));
    $this->rmeData = htmlspecialchars(strip_tags($this->rmeData));
    $this->rmeidProduto = htmlspecialchars(strip_tags($this->rmeidProduto));
    $this->rmeQuantidadeProduto = htmlspecialchars(strip_tags($this->rmeQuantidadeProduto));
    $this->rmeFilter = htmlspecialchars(strip_tags($this->rmeFilter));
    $this->rmeAutorizar = htmlspecialchars(strip_tags($this->rmeAutorizar));
    $this->rmeCriadoPor = htmlspecialchars(strip_tags($this->rmeCriadoPor));
    $this->rmeObservacaoGeral = htmlspecialchars(strip_tags($this->rmeObservacaoGeral));
    $this->rmeUnidadeCliente = htmlspecialchars(strip_tags($this->rmeUnidadeCliente));
    $this->rmeNomeCliente = htmlspecialchars(strip_tags($this->rmeNomeCliente));
    $this->rmeAtendimento = htmlspecialchars(strip_tags($this->rmeAtendimento));
    $this->rmeStatus = htmlspecialchars(strip_tags($this->rmeStatus));
    $this->rmeTeste = htmlspecialchars(strip_tags($this->rmeTeste));
    $this->rmeEmprestimo = htmlspecialchars(strip_tags($this->rmeEmprestimo));

    // BIND DATA
    $stmt->bindParam(':id', $this->id);
    $stmt->bindParam(':rmeResponsavel', $this->rmeResponsavel);
    $stmt->bindParam(':rmeDD', $this->rmeDD);
    $stmt->bindParam(':rmeOS', $this->rmeOS);
    $stmt->bindParam(':rmeDescricao', $this->rmeDescricao);
    $stmt->bindParam(':rmeObservacao', $this->rmeObservacao);
    $stmt->bindParam(':rmeData', $this->rmeData);
    $stmt->bindParam(':rmeidProduto', $this->rmeidProduto);
    $stmt->bindParam(':rmeQuantidadeProduto', $this->rmeQuantidadeProduto);
    $stmt->bindParam(':rmeFilter', $this->rmeFilter);
    $stmt->bindParam(':rmeAutorizar', $this->rmeAutorizar);
    $stmt->bindParam(':rmeCriadoPor', $this->rmeCriadoPor);
    $stmt->bindParam(':rmeObservacaoGeral', $this->rmeObservacaoGeral);
    $stmt->bindParam(':rmeUnidadeCliente', $this->rmeUnidadeCliente);
    $stmt->bindParam(':rmeNomeCliente', $this->rmeNomeCliente);
    $stmt->bindParam(':rmeAtendimento', $this->rmeAtendimento);
    $stmt->bindParam(':rmeStatus', $this->rmeStatus);
    $stmt->bindParam(':rmeTeste', $this->rmeTeste);
    $stmt->bindParam(':rmeEmprestimo', $this->rmeEmprestimo);
    
        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;
        }

    // DELETE POST
    public function delete(){
        
        // CREATE QUERY
        $query = 'DELETE FROM '. $this->table . ' WHERE id = :id';

        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);

        // CLEAN DATA
        $this->id = htmlspecialchars(strip_tags($this->id));

        // BIND DATA
        $stmt->bindParam(':id', $this->id);

        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;           
        }
}