<?php
Class Usuario{
    // DB STUFF
    private $conn;
    private $table = 'listaUsuarios';

    // POST PROPERTIES
    public $id;
    public $usuario;
    public $senha;
    public $permissao;
    public $nome;
    public $bloqueado;

    // CONSTRUCTOR WITH DB
    public function __construct($db){
        $this->conn = $db;
    }
    
    // GET POST
    public function read(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.usuario,
            p.senha,
            p.permissao,
            p.nome,
            p.bloqueado
        FROM
            ' . $this->table . ' p
        ORDER BY
            p.usuario ASC';
    
    // PREPARE STATEMENT
    $stmt = $this->conn->prepare($query);

    // EXECUTE QUERY
    $stmt->execute();
    
    return $stmt;
    }

    // GET SINGLE POST
    public function read_single(){
        // CREATE QUERY
        $query = 'SELECT
            p.id,
            p.usuario,
            p.senha,
            p.permissao,
            p.nome,
            p.bloqueado
        FROM
            ' . $this->table . ' p
        WHERE
            p.id = ?
        LIMIT 0,1';

        // PREPARE STATEMENT
        $stmt = $this->conn->prepare($query);

        // BIND ID
        $stmt->bindParam(1, $this->id);

        // EXECUTE QUERY
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        // SET PROPERTIES
        $this->usuario = $row['usuario'];
        $this->senha = $row['senha'];
        $this->permissao = $row['permissao'];
        $this->nome = $row['nome'];
        $this->bloqueado = $row['bloqueado'];
    }
    
    // CREATE POST
    public function create(){
        
    // CREATE QUERY
    $query= 'INSERT INTO ' . $this->table . '
        SET
            nome = :nome,
            senha = :senha,
            permissao = :permissao,
            bloqueado = :bloqueado,
            usuario = :usuario';

    // PREPARE STATEMENTE
    $stmt = $this->conn->prepare($query);

    // CLEAN DATA
    $this->nome = htmlspecialchars(strip_tags($this->nome));
    $this->senha = htmlspecialchars(strip_tags($this->senha));
    $this->permissao = htmlspecialchars(strip_tags($this->permissao));
    $this->usuario = htmlspecialchars(strip_tags($this->usuario));
    $this->bloqueado = htmlspecialchars(strip_tags($this->bloqueado));
    
    // BIND DATA
    $stmt->bindParam(':nome', $this->nome);
    $stmt->bindParam(':senha', $this->senha);
    $stmt->bindParam(':permissao', $this->permissao);
    $stmt->bindParam(':usuario', $this->usuario);
    $stmt->bindParam(':bloqueado', $this->bloqueado);
    
    // EXECUTE QUERY
    if($stmt->execute()){
        return true;
    }
    // PRINT ERROR IF SOMETHING GOES WRONG
    printf("Error: %s.\n",$stmt->error);
        return false;
    }
    
    // UPDATE POST
    public function update(){
    
        // CREATE QUERY
        $query= 'UPDATE ' . $this->table . '
            SET
            nome = :nome,
            senha = :senha,
            permissao = :permissao,
            usuario = :usuario,
            bloqueado = :bloqueado
            WHERE
                id = :id';
    
        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);
    
        // CLEAN DATA
    $this->id = htmlspecialchars(strip_tags($this->id));
    $this->nome = htmlspecialchars(strip_tags($this->nome));
    $this->permissao = htmlspecialchars(strip_tags($this->permissao));
    $this->usuario = htmlspecialchars(strip_tags($this->usuario));
    $this->senha = htmlspecialchars(strip_tags($this->senha));
    $this->bloqueado = htmlspecialchars(strip_tags($this->bloqueado));

    // BIND DATA
    $stmt->bindParam(':id', $this->id);
    $stmt->bindParam(':nome', $this->nome);
    $stmt->bindParam(':permissao', $this->permissao);
    $stmt->bindParam(':usuario', $this->usuario);
    $stmt->bindParam(':senha', $this->senha);
    $stmt->bindParam(':bloqueado', $this->bloqueado);
    
        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;
        }
    
    // DELETE POST
    public function delete(){
        
        // CREATE QUERY
        $query = 'DELETE FROM '. $this->table . ' WHERE id = :id';

        // PREPARE STATEMENTE
        $stmt = $this->conn->prepare($query);

        // CLEAN DATA
        $this->id = htmlspecialchars(strip_tags($this->id));

        // BIND DATA
        $stmt->bindParam(':id', $this->id);

        // EXECUTE QUERY
        if($stmt->execute()){
            return true;
        }
    
        // PRINT ERROR IF SOMETHING GOES WRONG
        printf("Error: %s.\n",$stmt->error);
    
            return false;           
        }
    
}